/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview.shape;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import uk.co.deanwild.materialshowcaseview.shape.Shape;
import uk.co.deanwild.materialshowcaseview.target.Target;

public class CircleShape
implements Shape {
    private int radius = 200;
    private boolean adjustToTarget = true;
    private int padding;

    public CircleShape() {
    }

    public CircleShape(int radius) {
        this.radius = radius;
    }

    public CircleShape(Rect bounds) {
        this(CircleShape.getPreferredRadius(bounds));
    }

    public CircleShape(Target target) {
        this(target.getBounds());
    }

    public void setAdjustToTarget(boolean adjustToTarget) {
        this.adjustToTarget = adjustToTarget;
    }

    public boolean isAdjustToTarget() {
        return this.adjustToTarget;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void draw(Canvas canvas, Paint paint, int x, int y) {
        if (this.radius > 0) {
            canvas.drawCircle((float)x, (float)y, (float)(this.radius + this.padding), paint);
        }
    }

    @Override
    public void updateTarget(Target target) {
        if (this.adjustToTarget) {
            this.radius = CircleShape.getPreferredRadius(target.getBounds());
        }
    }

    @Override
    public int getTotalRadius() {
        return this.radius + this.padding;
    }

    @Override
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public int getWidth() {
        return this.radius * 2;
    }

    @Override
    public int getHeight() {
        return this.radius * 2;
    }

    public static int getPreferredRadius(Rect bounds) {
        return Math.max(bounds.width(), bounds.height()) / 2;
    }
}

