/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.materialshowcaseview.target;

import android.app.Activity;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import uk.co.deanwild.materialshowcaseview.target.Target;

public class ViewTarget
implements Target {
    private final View mView;

    public ViewTarget(View view) {
        this.mView = view;
    }

    public ViewTarget(int viewId, Activity activity) {
        this.mView = activity.findViewById(viewId);
    }

    @Override
    public Point getPoint() {
        int[] location = new int[2];
        this.mView.getLocationInWindow(location);
        int x = location[0] + this.mView.getWidth() / 2;
        int y = location[1] + this.mView.getHeight() / 2;
        return new Point(x, y);
    }

    @Override
    public Rect getBounds() {
        int[] location = new int[2];
        this.mView.getLocationInWindow(location);
        return new Rect(location[0], location[1], location[0] + this.mView.getMeasuredWidth(), location[1] + this.mView.getMeasuredHeight());
    }

    public View getView() {
        return this.mView;
    }
}

