/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree.geometry.internal.RectangleFloat;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class CircleFloat
implements Circle {
    private final float x;
    private final float y;
    private final float radius;
    private final Rectangle mbr;

    protected CircleFloat(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.mbr = RectangleFloat.create(x - radius, y - radius, x + radius, y + radius);
    }

    public static CircleFloat create(float x, float y, float radius) {
        return new CircleFloat(x, y, radius);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double radius() {
        return this.radius;
    }

    @Override
    public Rectangle mbr() {
        return this.mbr;
    }

    @Override
    public double distance(Rectangle r) {
        return Math.max(0.0, GeometryUtil.distance(this.x, this.y, r) - (double)this.radius);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.distance(r) == 0.0;
    }

    @Override
    public boolean intersects(Circle c) {
        double total = (double)this.radius + c.radius();
        return GeometryUtil.distanceSquared(Geometries.point(this.x, this.y), Geometries.point(c.x(), c.y())) <= total * total;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.radius)});
    }

    public boolean equals(Object obj) {
        Optional<CircleFloat> other = ObjectsHelper.asClass(obj, CircleFloat.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x), (Object)Float.valueOf(((CircleFloat)other.get()).x)) && Objects.equal((Object)Float.valueOf(this.y), (Object)Float.valueOf(((CircleFloat)other.get()).y)) && Objects.equal((Object)Float.valueOf(this.radius), (Object)Float.valueOf(((CircleFloat)other.get()).radius));
        }
        return false;
    }

    @Override
    public boolean intersects(Point point) {
        return Math.sqrt(this.sqr((double)this.x - point.x()) + this.sqr((double)this.y - point.y())) <= (double)this.radius;
    }

    private double sqr(double x) {
        return x * x;
    }

    @Override
    public boolean intersects(Line line) {
        return line.intersects(this);
    }

    @Override
    public boolean isDoublePrecision() {
        return false;
    }
}

