/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import java.util.Comparator;
import java.util.List;

public final class Comparators {
    private Comparators() {
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> overlapAreaThenAreaIncreaseThenAreaComparator(final Rectangle r, final List<T> list) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                int value = Float.compare(Comparators.overlapArea(r, list, g1), Comparators.overlapArea(r, list, g2));
                if (value == 0 && (value = Float.compare(Comparators.areaIncrease(r, g1), Comparators.areaIncrease(r, g2))) == 0) {
                    value = Float.compare(Comparators.area(r, g1), Comparators.area(r, g2));
                }
                return value;
            }
        };
    }

    private static float area(Rectangle r, HasGeometry g1) {
        return g1.geometry().mbr().add(r).area();
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> areaIncreaseThenAreaComparator(final Rectangle r) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                int value = Float.compare(Comparators.areaIncrease(r, g1), Comparators.areaIncrease(r, g2));
                if (value == 0) {
                    value = Float.compare(Comparators.area(r, g1), Comparators.area(r, g2));
                }
                return value;
            }
        };
    }

    private static float overlapArea(Rectangle r, List<? extends HasGeometry> list, HasGeometry g) {
        Rectangle gPlusR = g.geometry().mbr().add(r);
        float m = 0.0f;
        for (HasGeometry hasGeometry : list) {
            if (hasGeometry == g) continue;
            m += gPlusR.intersectionArea(hasGeometry.geometry().mbr());
        }
        return m;
    }

    private static float areaIncrease(Rectangle r, HasGeometry g) {
        Rectangle gPlusR = g.geometry().mbr().add(r);
        return gPlusR.area() - g.geometry().mbr().area();
    }

    public static <T, S extends Geometry> Comparator<Entry<T, S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<T, S>>(){

            @Override
            public int compare(Entry<T, S> e1, Entry<T, S> e2) {
                return Double.compare(e1.geometry().distance(r), e2.geometry().distance(r));
            }
        };
    }
}

