/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.rtree.geometry.Group;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import java.util.List;

public final class ListPair<T extends HasGeometry> {
    private final Group<T> group1;
    private final Group<T> group2;
    private float areaSum = -1.0f;
    private final float marginSum;

    public ListPair(List<T> list1, List<T> list2) {
        this.group1 = new Group<T>(list1);
        this.group2 = new Group<T>(list2);
        this.marginSum = this.group1.geometry().mbr().perimeter() + this.group2.geometry().mbr().perimeter();
    }

    public Group<T> group1() {
        return this.group1;
    }

    public Group<T> group2() {
        return this.group2;
    }

    public float areaSum() {
        if (this.areaSum == -1.0f) {
            this.areaSum = this.group1.geometry().mbr().area() + this.group2.geometry().mbr().area();
        }
        return this.areaSum;
    }

    public float marginSum() {
        return this.marginSum;
    }
}

