/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import java.util.List;
import rx.functions.Func1;

public final class Functions {
    public static final Func1<ListPair<? extends HasGeometry>, Double> overlapListPair = new Func1<ListPair<? extends HasGeometry>, Double>(){

        public Double call(ListPair<? extends HasGeometry> pair) {
            return pair.group1().geometry().mbr().intersectionArea(pair.group2().geometry().mbr());
        }
    };
    private static final Func1<Object, Object> IDENTITY = new Func1<Object, Object>(){

        public Object call(Object o) {
            return o;
        }
    };

    private Functions() {
    }

    public static Func1<HasGeometry, Double> overlapArea(final Rectangle r, final List<? extends HasGeometry> list) {
        return new Func1<HasGeometry, Double>(){

            public Double call(HasGeometry g) {
                Rectangle gPlusR = g.geometry().mbr().add(r);
                double m = 0.0;
                for (HasGeometry other : list) {
                    if (other == g) continue;
                    m += (double)gPlusR.intersectionArea(other.geometry().mbr());
                }
                return m;
            }
        };
    }

    public static Func1<HasGeometry, Double> areaIncrease(final Rectangle r) {
        return new Func1<HasGeometry, Double>(){

            public Double call(HasGeometry g) {
                Rectangle gPlusR = g.geometry().mbr().add(r);
                return gPlusR.area() - g.geometry().mbr().area();
            }
        };
    }

    public static <T> Func1<T, T> identity() {
        return IDENTITY;
    }
}

