/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Backpressure;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodePosition;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.util.ImmutableStack;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Func1;

final class OnSubscribeSearch<T, S extends Geometry>
implements Observable.OnSubscribe<Entry<T, S>> {
    private final Node<T, S> node;
    private final Func1<? super Geometry, Boolean> condition;

    OnSubscribeSearch(Node<T, S> node, Func1<? super Geometry, Boolean> condition) {
        this.node = node;
        this.condition = condition;
    }

    public void call(Subscriber<? super Entry<T, S>> subscriber) {
        subscriber.setProducer(new SearchProducer<T, S>(this.node, this.condition, subscriber));
    }

    private static class SearchProducer<T, S extends Geometry>
    implements Producer {
        private final Subscriber<? super Entry<T, S>> subscriber;
        private final Node<T, S> node;
        private final Func1<? super Geometry, Boolean> condition;
        private volatile ImmutableStack<NodePosition<T, S>> stack;
        private final AtomicLong requested = new AtomicLong(0L);

        SearchProducer(Node<T, S> node, Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T, S>> subscriber) {
            this.node = node;
            this.condition = condition;
            this.subscriber = subscriber;
            this.stack = ImmutableStack.create(new NodePosition<T, S>(node, 0));
        }

        public void request(long n) {
            try {
                if (this.requested.get() == Long.MAX_VALUE) {
                    return;
                }
                if (n == Long.MAX_VALUE) {
                    this.requestAll();
                } else {
                    this.requestSome(n);
                }
            }
            catch (RuntimeException e) {
                this.subscriber.onError((Throwable)e);
            }
        }

        private void requestAll() {
            this.requested.set(Long.MAX_VALUE);
            this.node.search(this.condition, this.subscriber);
            if (!this.subscriber.isUnsubscribed()) {
                this.subscriber.onCompleted();
            }
        }

        private void requestSome(long n) {
            long previousCount = this.requested.getAndAdd(n);
            if (previousCount == 0L) {
                while (true) {
                    long r;
                    long numToEmit = r = this.requested.get();
                    this.stack = Backpressure.search(this.condition, this.subscriber, this.stack, numToEmit);
                    if (this.stack.isEmpty()) {
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onCompleted();
                            continue;
                        }
                        return;
                    }
                    if (this.requested.addAndGet(-r) == 0L) break;
                }
                return;
            }
        }
    }
}

