/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.RectangleDepth;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;

public final class Visualizer {
    private final RTree<?> tree;
    private final int width;
    private final int height;
    private final Rectangle view;
    private final int maxDepth;

    Visualizer(RTree<?> tree, int width, int height, Rectangle view) {
        this.tree = tree;
        this.width = width;
        this.height = height;
        this.view = view;
        this.maxDepth = Visualizer.calculateMaxDepth(tree.root());
    }

    private static <R> int calculateMaxDepth(Optional<Node<R>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return Visualizer.calculateDepth((Node)root.get(), 0);
    }

    private static <R> int calculateDepth(Node<R> node, int depth) {
        if (node instanceof Leaf) {
            return depth + 1;
        }
        return Visualizer.calculateDepth(((NonLeaf)node).children().get(0), depth + 1);
    }

    public BufferedImage create() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setBackground(Color.white);
        g.clearRect(0, 0, this.width, this.height);
        g.setComposite(AlphaComposite.getInstance(3, 0.75f));
        if (this.tree.root().isPresent()) {
            List<RectangleDepth> nodeDepths = this.getNodeDepthsSortedByDepth((Node)this.tree.root().get());
            this.drawNode(g, nodeDepths);
        }
        return image;
    }

    private <T> List<RectangleDepth> getNodeDepthsSortedByDepth(Node<T> root) {
        List<RectangleDepth> list = this.getRectangleDepths(root, 0);
        Collections.sort(list, new Comparator<RectangleDepth>(){

            @Override
            public int compare(RectangleDepth n1, RectangleDepth n2) {
                return Integer.valueOf(n1.getDepth()).compareTo(n2.getDepth());
            }
        });
        return list;
    }

    private <T> List<RectangleDepth> getRectangleDepths(Node<T> node, int depth) {
        ArrayList<RectangleDepth> list = new ArrayList<RectangleDepth>();
        list.add(new RectangleDepth(node.geometry().mbr(), depth));
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            for (Entry entry : leaf.entries()) {
                list.add(new RectangleDepth(entry.geometry().mbr(), depth + 2));
            }
        } else {
            NonLeaf n = (NonLeaf)node;
            for (Node child : n.children()) {
                list.addAll(this.getRectangleDepths(child, depth + 1));
            }
        }
        return list;
    }

    private void drawNode(Graphics2D g, List<RectangleDepth> nodes) {
        for (RectangleDepth node : nodes) {
            Color color = Color.getHSBColor((float)node.getDepth() / ((float)this.maxDepth + 1.0f), 1.0f, 1.0f);
            g.setStroke(new BasicStroke(Math.max(0.5f, (float)(this.maxDepth - node.getDepth() + 1 - 1))));
            g.setColor(color);
            Rectangle r = node.getRectangle();
            this.drawRectangle(g, r);
        }
    }

    private void drawRectangle(Graphics2D g, Rectangle r) {
        double x1 = (r.x1() - this.view.x1()) / (this.view.x2() - this.view.x1()) * (float)this.width;
        double y1 = (r.y1() - this.view.y1()) / (this.view.y2() - this.view.y1()) * (float)this.height;
        double x2 = (r.x2() - this.view.x1()) / (this.view.x2() - this.view.x1()) * (float)this.width;
        double y2 = (r.y2() - this.view.y1()) / (this.view.y2() - this.view.y1()) * (float)this.height;
        g.drawRect(Visualizer.rnd(x1), Visualizer.rnd(y1), Visualizer.rnd(x2 - x1), Visualizer.rnd(y2 - y1));
    }

    private static int rnd(double d) {
        return (int)Math.round(d);
    }

    public void save(File file, String imageFormat) {
        try {
            ImageIO.write((RenderedImage)this.create(), imageFormat, file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(String filename, String imageFormat) {
        this.save(new File(filename), imageFormat);
    }

    public void save(String filename) {
        this.save(new File(filename), "PNG");
    }
}

