/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Util {
    private Util() {
    }

    static void instantiateForTestCoveragePurposesOnly() {
        new Util();
    }

    public static Rectangle mbr(Collection<? extends HasGeometry> items) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        Optional r = Optional.absent();
        for (HasGeometry hasGeometry : items) {
            if (r.isPresent()) {
                r = Optional.of((Object)((Rectangle)r.get()).add(hasGeometry.geometry().mbr()));
                continue;
            }
            r = Optional.of((Object)hasGeometry.geometry().mbr());
        }
        return (Rectangle)r.get();
    }

    static <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return result;
    }

    static <T> List<T> remove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return result;
    }

    static <T> List<? extends T> replace(List<? extends T> list, T node, List<? extends T> replacements) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(node);
        result.addAll(replacements);
        return result;
    }
}

