/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.Util;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.util.ImmutableStack;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import rx.Subscriber;
import rx.functions.Func1;

final class Leaf<T>
implements Node<T> {
    private final List<Entry<T>> entries;
    private final Rectangle mbr;
    private final Context context;

    Leaf(List<Entry<T>> entries, Context context) {
        this.entries = entries;
        this.context = context;
        this.mbr = Util.mbr(entries);
    }

    private Leaf(Entry<T> entry, Context context) {
        this(Collections.singletonList(entry), context);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    List<Entry<T>> entries() {
        return this.entries;
    }

    @Override
    public Node<T> add(Entry<T> entry, ImmutableStack<NonLeaf<T>> stack) {
        List<Entry<T>> newChildren = Util.add(this.entries, entry);
        if (newChildren.size() <= this.context.maxChildren()) {
            Leaf<T> leaf = new Leaf<T>(newChildren, this.context);
            return (Node)Leaf.replace(this, leaf, stack, this.context).get();
        }
        ListPair<Entry<T>> pair = this.context.splitter().split(newChildren, this.context.minChildren());
        Leaf<T> leaf1 = new Leaf<T>(pair.group1().list(), this.context);
        Leaf<T> leaf2 = new Leaf<T>(pair.group2().list(), this.context);
        List<Leaf> list = Arrays.asList(leaf1, leaf2);
        return (Node)Leaf.replace(this, list, stack, this.context).get();
    }

    private static <R> Optional<Node<R>> replace(Node<R> node, Node<R> replacement, ImmutableStack<NonLeaf<R>> stack, Context context) {
        return Leaf.replace(node, Collections.singletonList(replacement), stack, context);
    }

    private static <R> Optional<Node<R>> replace(Node<R> node, List<? extends Node<R>> replacements, ImmutableStack<NonLeaf<R>> stack, Context context) {
        if (stack.isEmpty() && replacements.size() == 0) {
            return Optional.absent();
        }
        if (stack.isEmpty() && replacements.size() == 1) {
            return Optional.of(replacements.get(0));
        }
        if (stack.isEmpty()) {
            return Optional.of(new NonLeaf(replacements, context));
        }
        return Leaf.replaceWhenStackNonEmpty(node, replacements, stack, context);
    }

    private static <R> Optional<Node<R>> replaceWhenStackNonEmpty(Node<R> node, List<? extends Node<R>> replacements, ImmutableStack<NonLeaf<R>> stack, Context context) {
        NonLeaf<R> n = stack.peek();
        List<Node<R>> newChildren = Util.replace(n.children(), node, replacements);
        if (newChildren.size() == 0) {
            return Leaf.replace(n, Collections.emptyList(), stack.pop(), context);
        }
        if (newChildren.size() <= context.maxChildren()) {
            NonLeaf newNode = new NonLeaf(newChildren, context);
            return Leaf.replace(n, newNode, stack.pop(), context);
        }
        ListPair<Node<R>> pair = context.splitter().split(newChildren, context.minChildren());
        NonLeaf node1 = new NonLeaf(pair.group1().list(), context);
        NonLeaf node2 = new NonLeaf(pair.group2().list(), context);
        ArrayList nodes = Lists.newArrayList((Object[])new NonLeaf[]{node1, node2});
        return Leaf.replace(n, nodes, stack.pop(), context);
    }

    @Override
    public Optional<Node<T>> delete(Entry<T> entry, ImmutableStack<NonLeaf<T>> stack) {
        if (!this.entries.contains(entry)) {
            if (stack.isEmpty()) {
                return Optional.of((Object)this);
            }
            return Optional.absent();
        }
        List<Entry<T>> newChildren = Util.remove(this.entries, entry);
        if (newChildren.size() >= this.context.minChildren()) {
            Leaf<T> leaf = new Leaf<T>(newChildren, this.context);
            return Leaf.replace(this, leaf, stack, this.context);
        }
        return this.removeChildrenAndReadd(stack, newChildren);
    }

    private Optional<Node<T>> removeChildrenAndReadd(ImmutableStack<NonLeaf<T>> stack, List<Entry<T>> newChildren) {
        Optional afterRemoveAllChildren = Leaf.replace(this, Collections.emptyList(), stack, this.context);
        Optional result = Optional.absent();
        for (Entry<T> child : newChildren) {
            if (!result.isPresent()) {
                if (afterRemoveAllChildren.isPresent()) {
                    result = afterRemoveAllChildren;
                    result = Optional.of(((Node)result.get()).add(child, ImmutableStack.empty()));
                    continue;
                }
                result = Optional.of(new Leaf<T>(child, this.context));
                continue;
            }
            result = Optional.of(((Node)result.get()).add(child, ImmutableStack.empty()));
        }
        return result;
    }

    @Override
    public void search(Func1<? super Geometry, Boolean> criterion, Subscriber<? super Entry<T>> subscriber) {
        for (Entry<T> entry : this.entries) {
            if (subscriber.isUnsubscribed()) {
                return;
            }
            if (!((Boolean)criterion.call((Object)entry.geometry())).booleanValue()) continue;
            subscriber.onNext(entry);
        }
    }

    public String toString() {
        return "Leaf [entries=" + this.entries + ", mbr=" + this.mbr + "]";
    }

    @Override
    public int count() {
        return this.entries.size();
    }
}

