/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Functions;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import java.util.Comparator;
import java.util.List;
import rx.functions.Func1;

public final class Comparators {
    public static final Comparator<ListPair<?>> overlapListPairComparator = Comparators.toComparator(Functions.overlapListPair);
    public static Comparator<ListPair<?>> areaPairComparator = new Comparator<ListPair<?>>(){

        @Override
        public int compare(ListPair<?> p1, ListPair<?> p2) {
            return Float.valueOf(p1.areaSum()).compareTo(Float.valueOf(p2.areaSum()));
        }
    };

    public static <T extends HasGeometry> Comparator<HasGeometry> overlapAreaComparator(Rectangle r, List<T> list) {
        return Comparators.toComparator(Functions.overlapArea(r, list));
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> areaIncreaseComparator(Rectangle r) {
        return Comparators.toComparator(Functions.areaIncrease(r));
    }

    public static Comparator<HasGeometry> areaComparator(final Rectangle r) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                return Float.valueOf(g1.geometry().mbr().add(r).area()).compareTo(Float.valueOf(g2.geometry().mbr().add(r).area()));
            }
        };
    }

    public static <R, T extends Comparable<T>> Comparator<R> toComparator(final Func1<R, T> function) {
        return new Comparator<R>(){

            @Override
            public int compare(R g1, R g2) {
                return ((Comparable)function.call(g1)).compareTo(function.call(g2));
            }
        };
    }

    public static <T> Comparator<T> compose(final Comparator<T> ... comparators) {
        return new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                for (Comparator comparator : comparators) {
                    int value = comparator.compare(t1, t2);
                    if (value == 0) continue;
                    return value;
                }
                return 0;
            }
        };
    }

    public static final <S> Comparator<Entry<S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<S>>(){

            @Override
            public int compare(Entry<S> e1, Entry<S> e2) {
                return Double.valueOf(e1.geometry().distance(r)).compareTo(e2.geometry().distance(r));
            }
        };
    }
}

