/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.util.ObjectsHelper;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class Entry<T>
implements HasGeometry {
    private final T value;
    private final Geometry geometry;

    public Entry(T value, Geometry geometry) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull((Object)geometry);
        this.value = value;
        this.geometry = geometry;
    }

    public static <T> Entry<T> entry(T value, Geometry geometry) {
        return new Entry<T>(value, geometry);
    }

    public T value() {
        return this.value;
    }

    @Override
    public Geometry geometry() {
        return this.geometry;
    }

    public String toString() {
        return "Entry [value=" + this.value + ", geometry=" + this.geometry + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.geometry});
    }

    public boolean equals(Object obj) {
        Optional<Entry> other = ObjectsHelper.asClass(obj, Entry.class);
        if (other.isPresent()) {
            return Objects.equal(this.value, ((Entry)other.get()).value) && Objects.equal((Object)this.geometry, (Object)((Entry)other.get()).geometry);
        }
        return false;
    }
}

