/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.projection.ProjectorBounds;
import com.github.davidmoten.grumpy.wms.MissingMandatoryParameterException;
import com.github.davidmoten.util.servlet.RequestUtil;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;

public class WmsRequest {
    private static final String DATETIME_FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss";
    private List<String> layers = new ArrayList<String>();
    private List<String> queryLayers = new ArrayList<String>();
    private List<String> styles = new ArrayList<String>();
    private final ProjectorBounds bounds;
    private final String format;
    private final int width;
    private final int height;
    private final boolean transparent;
    private final Color backgroundColor;
    private final String version;
    private final String infoFormat;
    private final Map<String, String> parameters;
    private final Date time;

    public WmsRequest(List<String> layers, List<String> queryLayers, List<String> styles, ProjectorBounds bounds, String format, int width, int height, boolean transparent, Color backgroundColor, String version, String infoFormat, Map<String, String> parameters, Date time) {
        this.layers = layers;
        this.queryLayers = queryLayers;
        this.styles = styles;
        this.bounds = bounds;
        this.format = format;
        this.width = width;
        this.height = height;
        this.transparent = transparent;
        this.backgroundColor = backgroundColor;
        this.version = version;
        this.infoFormat = infoFormat;
        this.parameters = parameters;
        this.time = time;
    }

    public WmsRequest(HttpServletRequest request) throws MissingMandatoryParameterException {
        this(RequestUtil.getList(request, "LAYERS", true), RequestUtil.getList(request, "QUERY_LAYERS", false), RequestUtil.getList(request, "STYLES", true), WmsRequest.getBounds(WmsRequest.getEffectiveCrs(request), RequestUtil.getParameter(request, "BBOX", true), WmsRequest.getVersion(request)), RequestUtil.getParameter(request, "FORMAT", true), Integer.parseInt(RequestUtil.getParameter(request, "WIDTH", true)), Integer.parseInt(RequestUtil.getParameter(request, "HEIGHT", true)), WmsRequest.isTransparent(request), WmsRequest.getBackgroundColor(request), WmsRequest.getVersion(request), RequestUtil.getParameter(request, "INFO_FORMAT", false), WmsRequest.getParameters(request), WmsRequest.getTime(request));
    }

    public WmsRequest(String layers, String queryLayers, String styles, String crs, String srs, String bbox, String format, String width, String height, String transparent, String bgColor, String version, String infoFormat, Map<String, String> parameters, String time) {
        this(WmsRequest.list(WmsRequest.checkNotBlank(layers, "LAYERS")), WmsRequest.list(queryLayers), WmsRequest.list(styles), WmsRequest.getBounds(WmsRequest.getEffectiveCrs(srs, crs), WmsRequest.checkNotBlank(bbox, "BBOX"), version), WmsRequest.checkNotBlank(format, "FORMAT"), WmsRequest.parseInt(width, "WIDTH"), WmsRequest.parseInt(height, "HEIGHT"), "true".equalsIgnoreCase(transparent), WmsRequest.getColor(bgColor, "BGCOLOR"), WmsRequest.checkNotBlank(version, "VERSION"), infoFormat, parameters, WmsRequest.getTime(time));
    }

    private static int parseInt(String s, String name) {
        try {
            return Integer.parseInt(WmsRequest.checkNotBlank(s, name));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " is not a valid integer: " + s);
        }
    }

    private static String checkNotBlank(String s, String name) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " parameter must be present");
        }
        return s;
    }

    private static List<String> list(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(","));
    }

    private static Date getTime(HttpServletRequest request) throws MissingMandatoryParameterException {
        String s = RequestUtil.getParameter(request, "TIME", false);
        return WmsRequest.getTime(s);
    }

    private static Date getTime(String s) {
        if (s != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT_ISO_8601);
            try {
                return sdf.parse(s);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("TIME invalid format: " + e.getMessage());
            }
        }
        return null;
    }

    private static Map<String, String> getParameters(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    public WmsRequest modifySize(int w, int h) {
        return new WmsRequest(this.layers, this.queryLayers, this.styles, this.bounds, this.format, w, h, this.transparent, this.backgroundColor, this.version, this.infoFormat, this.parameters, this.time);
    }

    public String getVersion() {
        return this.version;
    }

    public WmsRequest modifyStyles(List<String> newStyles) {
        return new WmsRequest(this.layers, this.queryLayers, newStyles, this.bounds, this.format, this.width, this.height, this.transparent, this.backgroundColor, this.version, this.infoFormat, this.parameters, this.time);
    }

    public WmsRequest modifyBounds(ProjectorBounds newBounds) {
        return new WmsRequest(this.layers, this.queryLayers, this.styles, newBounds, this.format, this.width, this.height, this.transparent, this.backgroundColor, this.version, this.infoFormat, this.parameters, this.time);
    }

    public List<String> getQueryLayers() {
        if (this.queryLayers.size() == 0) {
            return this.layers;
        }
        return this.queryLayers;
    }

    public String getParam(String name) {
        return this.parameters.get(name);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    private static boolean isTransparent(HttpServletRequest request) throws MissingMandatoryParameterException {
        return "true".equalsIgnoreCase(RequestUtil.getParameter(request, "TRANSPARENT", false));
    }

    private static String getVersion(HttpServletRequest request) throws MissingMandatoryParameterException {
        return RequestUtil.getParameter(request, "VERSION", false);
    }

    private static Color getBackgroundColor(HttpServletRequest request) throws MissingMandatoryParameterException {
        String s = RequestUtil.getParameter(request, "BGCOLOR", false);
        return WmsRequest.getColor(s, "BGCOLOR");
    }

    private static Color getColor(String s, String name) {
        try {
            if (s != null) {
                return new Color(Integer.valueOf(s.substring(2), 16));
            }
            return Color.white;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid color format for " + name);
        }
    }

    private static String getEffectiveCrs(HttpServletRequest request) throws MissingMandatoryParameterException {
        String srs = request.getParameter("SRS");
        String crs = RequestUtil.getParameter(request, "CRS", false);
        return WmsRequest.getEffectiveCrs(srs, crs);
    }

    private static String getEffectiveCrs(String srs, String crs) {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{crs, srs, "EPSG:4326"});
    }

    public String toString() {
        return "WmsRequest [layers=" + this.layers + ", queryLayers=" + this.queryLayers + ", styles=" + this.styles + ", bounds=" + this.bounds + ", format=" + this.format + ", width=" + this.width + ", height=" + this.height + ", transparent=" + this.transparent + ", backgroundColor=" + this.backgroundColor + ", version=" + this.version + ", infoFormat=" + this.infoFormat + ", parameters=" + this.parameters + "]";
    }

    private static ProjectorBounds getBounds(String crs, String s, String version) {
        double maxLat;
        double maxLong;
        double minLat;
        double minLong;
        if (s == null) {
            return null;
        }
        String[] items = s.split(",");
        try {
            if ("1.1.1".equals(version) || "1.1.0".equals(version) || !"CRS:84".equals(crs) && !"EPSG:4326".equals(crs)) {
                minLong = Double.parseDouble(items[0]);
                minLat = Double.parseDouble(items[1]);
                maxLong = Double.parseDouble(items[2]);
                maxLat = Double.parseDouble(items[3]);
            } else {
                minLat = Double.parseDouble(items[0]);
                minLong = Double.parseDouble(items[1]);
                maxLat = Double.parseDouble(items[2]);
                maxLong = Double.parseDouble(items[3]);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("BBOX invalid, should be decimal,decimal,decimal,decimal");
        }
        return new ProjectorBounds(crs, minLong, minLat, maxLong, maxLat);
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public String getCrs() {
        return this.bounds.getSrs();
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ProjectorBounds getBounds() {
        return this.bounds;
    }

    public String getInfoFormat() {
        return this.infoFormat;
    }

    public Date getTime() {
        return this.time;
    }
}

