/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.core.Position;
import com.github.davidmoten.grumpy.projection.Projector;
import com.vividsolutions.jts.geom.Point;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class RendererUtil {
    public static void useAntialiasing(Graphics2D g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.addRenderingHints(renderHints);
    }

    public static List<GeneralPath> toPathGreatCircle(Projector projector, List<Position> positions) {
        return RendererUtil.toPath(projector, Position.interpolateLongitude(positions));
    }

    public static List<GeneralPath> toPath(Projector projector, List<Position> positions) {
        ArrayList<GeneralPath> list = new ArrayList<GeneralPath>();
        if (positions.size() < 2) {
            throw new RuntimeException("must provide at least two positions");
        }
        list.add(RendererUtil.createPath(projector, positions, 0.0));
        list.add(RendererUtil.createPath(projector, positions, -projector.periodAtLat(0.0)));
        list.add(RendererUtil.createPath(projector, positions, projector.periodAtLat(0.0)));
        return list;
    }

    private static List<Point> getPathPoints(Projector projector, List<Position> positions, double deltaX) {
        ArrayList<Point> list = new ArrayList<Point>();
        Double firstPointLat = null;
        Double firstPointLon = null;
        Point firstPoint = null;
        for (Position pos : positions) {
            Position p = pos.normalizeLongitude();
            if (firstPoint == null) {
                firstPoint = projector.getFirstXAfter(projector, p.getLat(), p.getLon(), projector.getBounds().getMinX() + deltaX);
                firstPointLat = p.getLat();
                firstPointLon = p.getLon();
                list.add(firstPoint);
                continue;
            }
            Point point = projector.getGeometryPointInSrsRelativeTo(p.getLat(), p.getLon(), firstPointLat.doubleValue(), firstPointLon.doubleValue(), firstPoint.getX(), firstPoint.getY());
            list.add(point);
        }
        return list;
    }

    private static GeneralPath createPath(Projector projector, List<Position> positions, double deltaX) {
        List<Point> points = RendererUtil.getPathPoints(projector, positions, deltaX);
        GeneralPath path = new GeneralPath();
        boolean first = true;
        for (Point point : points) {
            Point2D.Double pt = projector.getTargetPoint(point);
            if (first) {
                path.moveTo(pt.x, pt.y);
                first = false;
                continue;
            }
            path.lineTo(pt.x, pt.y);
        }
        return path;
    }

    public static Point2D[] getPoints(Projector projector, List<Position> positions) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (Position position : positions) {
            points.add(projector.toPoint2D(position.getLat(), position.getLon()));
        }
        return points.toArray(new Point2D[0]);
    }

    public static List<Position> getCircle(Position position, double radiusKm, double numPoints) {
        ArrayList<Position> positions = new ArrayList<Position>();
        int i = 0;
        while ((double)i < numPoints) {
            double bearing = 360.0 * (double)i / numPoints;
            Position p = position.predict(radiusKm, bearing).normalizeLongitude();
            positions.add(p);
            ++i;
        }
        positions.add((Position)positions.get(0));
        return positions;
    }

    public static void draw(Graphics2D g, List<? extends Shape> shapes) {
        for (Shape shape : shapes) {
            g.draw(shape);
        }
    }

    public static void fill(Graphics2D g, List<? extends Shape> shapes) {
        for (Shape shape : shapes) {
            g.fill(shape);
        }
    }
}

