/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.Layers;
import com.github.davidmoten.grumpy.wms.RendererUtil;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LayerManager {
    private static Logger log = LoggerFactory.getLogger(LayerManager.class);
    private final Layers layers;
    private final ExecutorService executor;
    private static final boolean DRAW_IN_PARALLEL = true;
    private static final ImageObserver noActionImageObserver = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return false;
        }
    };

    LayerManager(Layers layers) {
        this.layers = layers;
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : gEnv.getAvailableFontFamilyNames()) {
            log.debug(name);
        }
        log.info("constructed");
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    }

    BufferedImage getImage(WmsRequest request) {
        MyGraphics graphics = this.createGraphics(request);
        Graphics2D g = graphics.graphics;
        log.info("painting image with layers");
        this.paintImage(request, g);
        g.dispose();
        log.info("image finished");
        return graphics.image;
    }

    Map<String, String> getInfos(Date time, WmsRequest request, Point point, String mimeType) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String layerName : request.getLayers()) {
            Layer layer = this.layers.getLayer(layerName);
            if (layer != null) {
                String info = layer.getInfo(time, request, point, mimeType);
                if (info == null) continue;
                map.put(layerName, info);
                continue;
            }
            log.warn("no getInfo implementation for layer: " + layerName);
        }
        return map;
    }

    private void prepareGraphics(Graphics2D g) {
        RendererUtil.useAntialiasing(g);
    }

    private MyGraphics createGraphics(WmsRequest request) {
        log.info("creating buffered image");
        BufferedImage image = new BufferedImage(request.getWidth(), request.getHeight(), 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        this.prepareGraphics(g);
        this.paintBackground(request, g);
        log.info("image ready");
        return new MyGraphics(image, g);
    }

    private void paintImage(WmsRequest request, Graphics2D g) {
        log.info("painting layers " + request.getLayers());
        this.paintImageParallel(request, g);
    }

    private void paintImageParallel(WmsRequest request, Graphics2D g) {
        ArrayList<Future<BufferedImage>> futures = new ArrayList<Future<BufferedImage>>();
        for (String string : request.getLayers()) {
            Callable<BufferedImage> worker = this.createWorker(this.layers, string, request);
            Future<BufferedImage> submit = this.executor.submit(worker);
            futures.add(submit);
        }
        for (Future future : futures) {
            this.drawImage(g, future);
        }
    }

    private Callable<BufferedImage> createWorker(final Layers layers, final String layerName, final WmsRequest request) {
        return new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                MyGraphics graphics = LayerManager.this.createGraphics(request);
                LayerManager.paintLayer(graphics.graphics, layerName, layers, request);
                return graphics.image;
            }
        };
    }

    private static void paintLayer(Graphics2D g, String layerName, Layers layers, WmsRequest request) {
        log.info("painting " + layerName);
        Layer layer = layers.getLayer(layerName);
        if (layer != null) {
            layer.render(g, request);
            log.info("finished painting " + layerName);
        } else {
            log.warn("no paintImage implementation for layer: " + layerName);
        }
    }

    private void drawImage(Graphics2D g, Future<BufferedImage> future) {
        try {
            BufferedImage image = future.get();
            g.drawImage((Image)image, 0, 0, noActionImageObserver);
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintBackground(WmsRequest request, Graphics2D g) {
        g.setColor(request.getBackgroundColor());
        g.setBackground(request.getBackgroundColor());
        if (request.isTransparent()) {
            g.setComposite(AlphaComposite.getInstance(1));
        } else {
            g.setComposite(AlphaComposite.getInstance(3, 0.0f));
        }
        g.fillRect(0, 0, 100, 100);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private static class MyGraphics {
        BufferedImage image;
        Graphics2D graphics;

        public MyGraphics(BufferedImage image, Graphics2D graphics) {
            this.image = image;
            this.graphics = graphics;
        }
    }
}

