/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui;

import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.util.OSUtil;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPathResolver {
    private static final Logger log = LoggerFactory.getLogger(ProjectPathResolver.class);
    private String sourcePath;
    private String resourcePath;
    private String baseProjectPath;
    private final String basePackage;
    private final Pattern packagePattern = Pattern.compile("[a-zA-Z]+[0-9a-zA-Z_]*(\\.[a-zA-Z]+[0-9a-zA-Z_]*)*");

    public ProjectPathResolver(String basePackage) {
        this.basePackage = basePackage;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        String rootPath = "";
        if (contextLoader.getResource(".") != null) {
            String projectDir = contextLoader.getResource(".").getPath();
            projectDir = this.getUTF8String(projectDir);
            String[] paths = projectDir.split("/");
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (Strings.isNullOrEmpty((String)path) || i >= paths.length - 2) continue;
                temp.append(path);
                temp.append(File.separator);
            }
            rootPath = temp.toString();
        } else {
            rootPath = this.getUTF8String(System.getProperty("user.dir")) + File.separator;
        }
        if (!OSUtil.isWindows() && !rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        this.refreshBaseProjectPath(rootPath);
    }

    public String getUTF8String(String basePath) {
        try {
            basePath = URLDecoder.decode(basePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return basePath;
    }

    public String convertPackageToPath(String packageName) {
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new ServiceException("\u5305\u540d\u4e3a\u7a7a");
        }
        boolean isResourceFile = false;
        if (packageName.startsWith("resources:")) {
            packageName = packageName.replaceFirst("resources:", "");
            isResourceFile = true;
        } else if (packageName.startsWith("java:")) {
            packageName = packageName.replaceFirst("java:", "");
        }
        if (!this.packagePattern.matcher(packageName).matches()) {
            throw new ServiceException("\u4e0d\u662f\u5408\u6cd5\u7684\u5305\u540d\uff1a" + packageName);
        }
        String[] folders = packageName.split("\\.");
        StringBuilder path = new StringBuilder(this.sourcePath);
        if (isResourceFile) {
            path = new StringBuilder(this.resourcePath);
        }
        for (String folder : folders) {
            path.append(File.separator).append(folder);
        }
        return path.toString();
    }

    public String convertPathToPackage(String path) {
        if (path.startsWith(this.sourcePath)) {
            path = path.replace(this.sourcePath, "");
        } else if (path.startsWith(this.resourcePath)) {
            path = path.replace(this.resourcePath, "");
        } else {
            throw new ServiceException("\u65e0\u6cd5\u5c06\u8be5\u8def\u5f84\u8f6c\u6362\u4e3a\u5305\u540d\uff1a" + path);
        }
        String packageStr = path.replace(File.separator, ".");
        if (packageStr.startsWith(".")) {
            packageStr = packageStr.substring(1, packageStr.length());
        }
        return packageStr;
    }

    public String resolveEntityPackage() {
        return PathUtil.joinPackage(this.basePackage, "entity");
    }

    public String resolveControllerPackage() {
        return PathUtil.joinPackage(this.basePackage, "controller");
    }

    public String resolveServicePackage() {
        return PathUtil.joinPackage(this.basePackage, "service");
    }

    public String resolveServiceImplPackage() {
        return PathUtil.joinPackage(this.basePackage, "service", "impl");
    }

    public String resolveMapperPackage() {
        return PathUtil.joinPackage(this.basePackage, "mapper");
    }

    public String resolveMapperXmlPackage() {
        return "resources:mapper";
    }

    public synchronized void refreshBaseProjectPath(String rootPath) {
        if (this.baseProjectPath == null || !this.baseProjectPath.equals(rootPath)) {
            this.baseProjectPath = rootPath;
            this.sourcePath = new File(this.baseProjectPath + "src/main/java".replace("/", File.separator)).toString();
            this.resourcePath = new File(this.baseProjectPath + "src/main/resources".replace("/", File.separator)).toString();
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getBaseProjectPath() {
        return this.baseProjectPath;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Pattern getPackagePattern() {
        return this.packagePattern;
    }
}

