/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;
import org.scilab.forge.jlatexmath.core.VerticalBox;
import org.scilab.forge.jlatexmath.core.XLeftRightArrowFactory;

public class XArrowAtom
extends Atom {
    private Atom over;
    private Atom under;
    private boolean left;

    public XArrowAtom(Atom over, Atom under, boolean left) {
        this.over = over;
        this.under = under;
        this.left = left;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box O = this.over != null ? this.over.createBox(env.supStyle()) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        Box U = this.under != null ? this.under.createBox(env.subStyle()) : new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        Box oside = new SpaceAtom(0, 1.5f, 0.0f, 0.0f).createBox(env.supStyle());
        Box uside = new SpaceAtom(0, 1.5f, 0.0f, 0.0f).createBox(env.subStyle());
        Box sep = new SpaceAtom(5, 0.0f, 2.0f, 0.0f).createBox(env);
        float width = Math.max(O.getWidth() + 2.0f * oside.getWidth(), U.getWidth() + 2.0f * uside.getWidth());
        Box arrow = XLeftRightArrowFactory.create(this.left, env, width);
        HorizontalBox ohb = new HorizontalBox(O, width, 2);
        HorizontalBox uhb = new HorizontalBox(U, width, 2);
        VerticalBox vb = new VerticalBox();
        vb.add(ohb);
        vb.add(sep);
        vb.add(arrow);
        vb.add(sep);
        vb.add(uhb);
        float h = vb.getHeight() + vb.getDepth();
        float d = sep.getHeight() + sep.getDepth() + uhb.getHeight() + uhb.getDepth();
        vb.setDepth(d);
        vb.setHeight(h - d);
        HorizontalBox hb = new HorizontalBox(vb, vb.getWidth() + 2.0f * sep.getHeight(), 2);
        return hb;
    }
}

