/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.FramedBox;

public class OvalBox
extends FramedBox {
    private float shadowRule;

    public OvalBox(FramedBox fbox) {
        super(fbox.box, fbox.thickness, fbox.space);
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        this.box.draw(g2, x + this.space + this.thickness, y);
        Paint st = AjLatexMath.getPaint();
        float w = st.getStrokeWidth();
        st.setStrokeWidth(this.thickness);
        Paint.Style s = st.getStyle();
        st.setStyle(Paint.Style.STROKE);
        float th = this.thickness / 2.0f;
        float r = 0.5f * Math.min(this.width - this.thickness, this.height + this.depth - this.thickness);
        g2.drawRoundRect(new RectF(x + th, y - this.height + th, x + th + this.width - this.thickness, y - this.height + th + this.height + this.depth - this.thickness), r, r, st);
        st.setStrokeWidth(w);
        st.setStyle(s);
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

