/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;

public class MulticolumnAtom
extends Atom {
    protected int n;
    protected int align;
    protected float w = 0.0f;
    protected Atom cols;
    protected int beforeVlines;
    protected int afterVlines;
    protected int row;
    protected int col;

    public MulticolumnAtom(int n, String align, Atom cols) {
        this.n = n >= 1 ? n : 1;
        this.cols = cols;
        this.align = this.parseAlign(align);
    }

    public void setWidth(float w) {
        this.w = w;
    }

    public int getSkipped() {
        return this.n;
    }

    public boolean hasRightVline() {
        return this.afterVlines != 0;
    }

    public void setRowColumn(int i, int j) {
        this.row = i;
        this.col = j;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    private int parseAlign(String str) {
        int len = str.length();
        int align = 2;
        boolean first = true;
        block6: for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            switch (c) {
                case 'l': {
                    align = 0;
                    first = false;
                    continue block6;
                }
                case 'r': {
                    align = 1;
                    first = false;
                    continue block6;
                }
                case 'c': {
                    align = 2;
                    first = false;
                    continue block6;
                }
                case '|': {
                    if (first) {
                        this.beforeVlines = 1;
                    } else {
                        this.afterVlines = 1;
                    }
                    while (++pos < len) {
                        c = str.charAt(pos);
                        if (c != '|') {
                            --pos;
                            continue block6;
                        }
                        if (first) {
                            ++this.beforeVlines;
                            continue;
                        }
                        ++this.afterVlines;
                    }
                    continue block6;
                }
            }
        }
        return align;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box b = this.w == 0.0f ? this.cols.createBox(env) : new HorizontalBox(this.cols.createBox(env), this.w, this.align);
        b.type = 12;
        return b;
    }
}

