/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;

public class HorizontalRule
extends Box {
    private Integer color = null;
    private float speShift = 0.0f;

    public HorizontalRule(float thickness, float width, float s) {
        this.height = thickness;
        this.width = width;
        this.shift = s;
    }

    public HorizontalRule(float thickness, float width, float s, boolean trueShift) {
        this.height = thickness;
        this.width = width;
        if (trueShift) {
            this.shift = s;
        } else {
            this.shift = 0.0f;
            this.speShift = s;
        }
    }

    public HorizontalRule(float thickness, float width, float s, Integer c) {
        this.height = thickness;
        this.width = width;
        this.color = c;
        this.shift = s;
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        Paint st = AjLatexMath.getPaint();
        Paint.Style s = st.getStyle();
        float w = st.getStrokeWidth();
        st.setStyle(Paint.Style.FILL);
        st.setStrokeWidth(0.0f);
        int c = st.getColor();
        if (this.color != null) {
            st.setColor(this.color.intValue());
        }
        if (this.speShift == 0.0f) {
            g2.drawRect(x, y - this.height, x + this.width, y, st);
        } else {
            g2.drawRect(x, y - this.height + this.speShift, x + this.width, y + this.speShift, st);
        }
        st.setColor(c);
        st.setStyle(s);
        st.setStrokeWidth(w);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

