/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.util.Map;
import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.GraphicsBox;
import org.scilab.forge.jlatexmath.core.ParseOption;
import org.scilab.forge.jlatexmath.core.ResizeAtom;
import org.scilab.forge.jlatexmath.core.RotateAtom;
import org.scilab.forge.jlatexmath.core.ScaleAtom;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFormula;

public class GraphicsAtom
extends Atom {
    private Bitmap image = null;
    private Bitmap bimage;
    private int w;
    private int h;
    private Atom base;
    private boolean first = true;
    private int interp = -1;

    public GraphicsAtom(String path, String option) {
        this.image = BitmapFactory.decodeFile((String)path);
        this.draw();
        this.buildAtom(option);
    }

    protected void buildAtom(String option) {
        this.base = this;
        Map<String, String> options = ParseOption.parseMap(option);
        if (options.containsKey("width") || options.containsKey("height")) {
            this.base = new ResizeAtom(this.base, options.get("width"), options.get("height"), options.containsKey("keepaspectratio"));
        }
        if (options.containsKey("scale")) {
            double scl = Double.parseDouble(options.get("scale"));
            this.base = new ScaleAtom(this.base, scl, scl);
        }
        if (options.containsKey("angle") || options.containsKey("origin")) {
            this.base = new RotateAtom(this.base, options.get("angle"), options.get("origin"));
        }
        if (options.containsKey("interpolation")) {
            String meth = options.get("interpolation");
            if (meth.equalsIgnoreCase("bilinear")) {
                this.interp = 0;
            } else if (meth.equalsIgnoreCase("bicubic")) {
                this.interp = 2;
            } else if (meth.equalsIgnoreCase("nearest_neighbor")) {
                this.interp = 1;
            }
        }
    }

    public void draw() {
        this.bimage = this.image;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.image != null) {
            if (this.first) {
                this.first = false;
                return this.base.createBox(env);
            }
            env.isColored = true;
            float width = (float)this.w * SpaceAtom.getFactor(2, env);
            float height = (float)this.h * SpaceAtom.getFactor(2, env);
            return new GraphicsBox(this.bimage, width, height, env.getSize(), this.interp);
        }
        return new TeXFormula((String)"\\text{ No such image file ! }").root.createBox(env);
    }
}

