/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;

public class FramedBox
extends Box {
    protected Box box;
    protected float thickness;
    protected float space;
    private Integer line;
    private Integer bg;

    public FramedBox(Box box, float thickness, float space) {
        this.box = box;
        this.width = box.width + 2.0f * thickness + 2.0f * space;
        this.height = box.height + thickness + space;
        this.depth = box.depth + thickness + space;
        this.shift = box.shift;
        this.thickness = thickness;
        this.space = space;
    }

    public FramedBox(Box box, float thickness, float space, Integer line, Integer bg) {
        this(box, thickness, space);
        this.line = line;
        this.bg = bg;
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        Paint st = AjLatexMath.getPaint();
        float w = st.getStrokeWidth();
        Paint.Style s = st.getStyle();
        int c = st.getColor();
        st.setStrokeWidth(this.thickness);
        st.setStyle(Paint.Style.FILL_AND_STROKE);
        float th = this.thickness / 2.0f;
        if (this.bg != null) {
            st.setColor(this.bg.intValue());
            g2.drawRect(x + th, y - this.height + th, x + th + this.width - this.thickness, y + th + this.depth - this.thickness, st);
        }
        st.setStyle(Paint.Style.STROKE);
        if (this.line != null) {
            st.setColor(this.line.intValue());
            g2.drawRect(x + th, y - this.height + th, x + th + this.width - this.thickness, y + th + this.depth - this.thickness, st);
        } else {
            g2.drawRect(x + th, y - this.height + th, x + th + this.width - this.thickness, y + th + this.depth - this.thickness, st);
        }
        st.setStrokeWidth(w);
        st.setStyle(s);
        this.box.draw(g2, x + this.space + this.thickness, y);
        st.setColor(c);
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

