/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import java.util.LinkedList;
import java.util.Stack;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.VerticalBox;

public final class BreakFormula {
    public static Box split(Box box, float width, float interline) {
        if (box instanceof HorizontalBox) {
            return BreakFormula.split((HorizontalBox)box, width, interline);
        }
        if (box instanceof VerticalBox) {
            return BreakFormula.split((VerticalBox)box, width, interline);
        }
        return box;
    }

    public static Box split(HorizontalBox hbox, float width, float interline) {
        VerticalBox vbox = new VerticalBox();
        HorizontalBox second = null;
        Stack<Position> positions = new Stack<Position>();
        float w = -1.0f;
        while (hbox.width > width && (w = BreakFormula.canBreak(positions, hbox, width)) != hbox.width) {
            Position pos = positions.pop();
            HorizontalBox[] hboxes = pos.hbox.split(pos.index - 1);
            HorizontalBox first = hboxes[0];
            second = hboxes[1];
            while (!positions.isEmpty()) {
                pos = positions.pop();
                hboxes = pos.hbox.splitRemove(pos.index);
                hboxes[0].add(first);
                hboxes[1].add(0, second);
                first = hboxes[0];
                second = hboxes[1];
            }
            vbox.add(first, interline);
            hbox = second;
        }
        if (second != null) {
            vbox.add(second, interline);
            return vbox;
        }
        return hbox;
    }

    private static Box split(VerticalBox vbox, float width, float interline) {
        VerticalBox newBox = new VerticalBox();
        for (Box box : vbox.children) {
            newBox.add(BreakFormula.split(box, width, interline));
        }
        return newBox;
    }

    private static float canBreak(Stack<Position> stack, HorizontalBox hbox, float width) {
        LinkedList children = hbox.children;
        float[] cumWidth = new float[children.size() + 1];
        cumWidth[0] = 0.0f;
        for (int i = 0; i < children.size(); ++i) {
            Stack<Position> newStack;
            float w;
            Box box = (Box)children.get(i);
            cumWidth[i + 1] = cumWidth[i] + box.width;
            if (!(cumWidth[i + 1] > width)) continue;
            int pos = BreakFormula.getBreakPosition(hbox, i);
            if (box instanceof HorizontalBox && (w = BreakFormula.canBreak(newStack = new Stack<Position>(), (HorizontalBox)box, width - cumWidth[i])) != box.width && (cumWidth[i] + w <= width || pos == -1)) {
                stack.push(new Position(i - 1, hbox));
                stack.addAll(newStack);
                return cumWidth[i] + w;
            }
            if (pos == -1) continue;
            stack.push(new Position(pos, hbox));
            return cumWidth[pos];
        }
        return hbox.width;
    }

    private static int getBreakPosition(HorizontalBox hb, int i) {
        int pos;
        if (hb.breakPositions == null) {
            return -1;
        }
        if (hb.breakPositions.size() == 1 && hb.breakPositions.get(0) <= i) {
            return hb.breakPositions.get(0);
        }
        for (pos = 0; pos < hb.breakPositions.size(); ++pos) {
            if (hb.breakPositions.get(pos) <= i) continue;
            if (pos == 0) {
                return -1;
            }
            return hb.breakPositions.get(pos - 1);
        }
        return hb.breakPositions.get(pos - 1);
    }

    private static class Position {
        int index;
        HorizontalBox hbox;

        Position(int index, HorizontalBox hbox) {
            this.index = index;
            this.hbox = hbox;
        }
    }
}

