/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielwegener.logback.kafka;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import com.github.danielwegener.logback.kafka.BlindLogger;
import com.github.danielwegener.logback.kafka.KafkaAppenderConfig;
import com.github.danielwegener.logback.kafka.delivery.FailedDeliveryCallback;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAppenderBase<E extends ILoggingEvent>
extends KafkaAppenderConfig<E> {
    private static final String KAFKA_LOGGER_PREFIX = "org.apache.kafka.clients";
    private final AppenderAttachableImpl<E> aai = new AppenderAttachableImpl();
    private Producer<byte[], byte[]> producer = null;
    private final FailedDeliveryCallback<E> failedDeliveryCallback = new FailedDeliveryCallback<E>(){

        @Override
        public void onFailedDelivery(E evt, Throwable throwable) {
            KafkaAppenderBase.this.aai.appendLoopOnAppenders(evt);
        }
    };

    protected Producer<byte[], byte[]> createProducer() {
        ByteArraySerializer serializer = new ByteArraySerializer();
        return new KafkaProducer(new HashMap(this.producerConfig), (Serializer)serializer, (Serializer)serializer);
    }

    public KafkaAppenderBase() {
        this.addFilter(new Filter<E>(){

            public FilterReply decide(E event) {
                if (event.getLoggerName().startsWith(KafkaAppenderBase.KAFKA_LOGGER_PREFIX)) {
                    return FilterReply.DENY;
                }
                return FilterReply.NEUTRAL;
            }
        });
    }

    protected void append(E e) {
        byte[] payload = this.encoder.doEncode(e);
        byte[] key = this.keyingStrategy.createKey((ILoggingEvent)e);
        ProducerRecord record = new ProducerRecord(this.topic, (Object)key, (Object)payload);
        this.deliveryStrategy.send(this.producer, record, e, this.failedDeliveryCallback);
    }

    public void start() {
        if (!this.checkPrerequisites()) {
            return;
        }
        BlindLogger blindLogger = new BlindLogger("blind", this.getStatusManager());
        this.producer = this.createProducer();
        super.start();
    }

    public void stop() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (KafkaException e) {
                this.addWarn("Failed to shut down kafka producer: " + e.getMessage(), e);
            }
            this.producer = null;
        }
        super.stop();
    }

    public boolean isStarted() {
        return super.isStarted();
    }

    public void addAppender(Appender<E> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<E> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<E> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<E> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }
}

