/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.metatest;

import com.github.dakusui.jcunit.core.Checks;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.requests.FilterRequest;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;

public class Metatest {
    public static final Expected defaultExpected = new Expected(){

        @Override
        public boolean passing() {
            return true;
        }

        @Override
        public Class<? extends Throwable> exception() {
            return Throwable.class;
        }

        @Override
        public String messagePattern() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Expected.class;
        }
    };

    public void executeTestMethod(Class<?> testClass, String testMethodName) {
        Checks.checknotnull(testClass);
        Checks.checknotnull(testMethodName);
        this.composeTestExpectation(testClass, testMethodName).check(this.runTestMethod(testClass, testMethodName));
    }

    protected Expectation composeTestExpectation(Class<?> testClass, String testMethodName) {
        try {
            Method m = testClass.getMethod(testMethodName, new Class[0]);
            String testName = String.format("%s#%s", testClass.getCanonicalName(), testMethodName);
            if (m.isAnnotationPresent(Expected.class)) {
                Expected expected = m.getAnnotation(Expected.class);
                return new Expectation(testName, expected);
            }
            return new Expectation(testName, defaultExpected);
        }
        catch (NoSuchMethodException e) {
            Checks.rethrowtesterror(e, String.format("The test '%s#%s' was not found", testClass.getCanonicalName(), testMethodName), new Object[0]);
            Checks.checkcond(false);
            return null;
        }
    }

    private Result runTestMethod(Class<?> testClass, String methodName) {
        return new JUnitCore().run(this.composeRequestForTestMethod(testClass, methodName));
    }

    protected Request composeRequestForTestMethod(final Class<?> testClass, final String methodName) {
        return new FilterRequest((Request)new ClassRequest(testClass), new Filter(){

            public boolean shouldRun(Description description) {
                return methodName.equals(description.getMethodName());
            }

            public String describe() {
                return String.format("%s#%s", testClass.getCanonicalName(), methodName);
            }
        });
    }

    protected static class Expectation {
        private final Expected expected;
        private final String testName;

        public Expectation(String testName, Expected expected) {
            Checks.checknotnull(testName);
            Checks.checknotnull(expected);
            if (expected.passing()) {
                Checks.checktest(Throwable.class.equals(expected.exception()) && "".equals(expected.messagePattern()), "%s: 'exception' and 'messagePattern' can't be set when 'passing' is set to true.", testName);
            }
            this.testName = testName;
            this.expected = expected;
        }

        public void check(Result result) {
            Checks.checknotnull(result);
            Checks.checkparam(result.getIgnoreCount() == 0);
            Checks.checkparam(result.getRunCount() == 1);
            Checks.checkparam(result.getFailures().size() <= 1);
            Checks.checkparam(result.getFailureCount() <= 1);
            ArrayList<String> violations = new ArrayList<String>();
            if (this.expected.passing()) {
                this.check(result.wasSuccessful(), "Test was expected to pass but failed", violations);
            } else {
                this.check(!result.wasSuccessful(), "Test was expected to fail but passed", violations);
                int c = result.getFailureCount();
                this.check(c == 1, String.format("Failure count was expected to be 1 but %d", c), violations);
            }
            if (!Throwable.class.equals(this.expected.exception()) && result.getFailures().size() > 0) {
                Throwable t = ((Failure)result.getFailures().get(0)).getException();
                this.check(this.expected.exception().isAssignableFrom(t.getClass()), String.format("An instance of '%s' was expected to be thrown but '%s' was thrown", this.expected.exception().getCanonicalName(), t.getClass().getCanonicalName()), violations);
            }
            if (!"".equals(this.expected.messagePattern()) && result.getFailures().size() > 0) {
                String msg = ((Failure)result.getFailures().get(0)).getMessage();
                this.check(msg.matches(this.expected.messagePattern()), String.format("Message should match the pattern: '%s' but didn't. The actual message was '%s'", this.expected.messagePattern(), msg), violations);
            }
            if (!violations.isEmpty()) {
                throw new MetatestAssertionFailedError(String.format("The test result for '%s' didn't meet the expectation. ", this.testName), violations);
            }
        }

        private void check(boolean cond, String message, List<String> violations) {
            if (!cond) {
                violations.add(message);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Expected {
        public boolean passing() default true;

        public Class<? extends Throwable> exception() default Throwable.class;

        public String messagePattern() default "";
    }

    public static class MetatestAssertionFailedError
    extends AssertionFailedError {
        public final List<String> violations;

        public MetatestAssertionFailedError(String message, List<String> violations) {
            super(MetatestAssertionFailedError.formatMessage(message, violations));
            this.violations = Collections.unmodifiableList(violations);
        }

        private static String formatMessage(String message, List<String> violations) {
            return message + violations;
        }
    }
}

