/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Constraint;
import com.github.dakusui.jcunit.core.FactorField;
import com.github.dakusui.jcunit.core.Generator;
import com.github.dakusui.jcunit.core.Param;
import com.github.dakusui.jcunit.core.TupleGeneration;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.FactorLoader;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.factor.LevelsProvider;
import com.github.dakusui.jcunit.exceptions.Errors;
import com.github.dakusui.jcunit.exceptions.InvalidTestException;
import com.github.dakusui.jcunit.fsm.Action;
import com.github.dakusui.jcunit.fsm.FSM;
import com.github.dakusui.jcunit.fsm.FSMLevelsProvider;
import com.github.dakusui.jcunit.fsm.FSMTupleGenerator;
import com.github.dakusui.jcunit.fsm.FSMUtils;
import com.github.dakusui.jcunit.fsm.Parameters;
import com.github.dakusui.jcunit.fsm.SimpleFSM;
import com.github.dakusui.jcunit.fsm.Story;
import com.github.dakusui.jcunit.fsm.spec.FSMSpec;
import com.github.dakusui.jcunit.generators.TupleGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TupleGeneratorFactory {
    public static final TupleGeneratorFactory INSTANCE = new TupleGeneratorFactory();

    public static <SUT> FSM<SUT> createFSM(String fsmName, Class<? extends FSMSpec<SUT>> fsmSpecClass, int historyLength) {
        return new SimpleFSM(fsmName, fsmSpecClass, historyLength);
    }

    public TupleGenerator createTupleGeneratorForClass(Class<?> klazz) {
        Checks.checknotnull(klazz);
        TupleGeneration tupleGenerationAnn = this.getTupleGenerationAnnotation(klazz);
        return this.createTupleGenerator(klazz, tupleGenerationAnn);
    }

    public TupleGenerator createTupleGeneratorForField(Field field) {
        Checks.checknotnull(field);
        TupleGeneration tupleGenerationAnn = this.getTupleGenerationAnnotation(field);
        return this.createTupleGenerator(field.getType(), tupleGenerationAnn);
    }

    private TupleGenerator createTupleGenerator(Class<?> klazz, TupleGeneration tupleGenerationAnn) {
        TupleGenerator generator;
        LinkedHashMap<Field, LevelsProvider> levelsProviders = new LinkedHashMap<Field, LevelsProvider>();
        Factors factors = this.loadFactors(klazz, levelsProviders);
        Constraint constraintAnn = tupleGenerationAnn.constraint();
        ConstraintManager constraintManager = new ConstraintManager.Builder().setConstraintManagerClass(constraintAnn.value()).setParameters(constraintAnn.params()).setFactors(factors).build();
        Generator generatorAnn = tupleGenerationAnn.generator();
        TupleGenerator.Builder b = new TupleGenerator.Builder().setTupleGeneratorClass(generatorAnn.value()).setConstraintManager(constraintManager).setParameters(generatorAnn.params()).setTargetClass(klazz).setFactors(factors);
        List<Field> fsmFields = TupleGeneratorFactory.extractFSMFactorFields(levelsProviders.keySet());
        if (!fsmFields.isEmpty()) {
            LinkedHashMap<String, FSM> fsms = new LinkedHashMap<String, FSM>();
            LinkedList<Parameters.LocalConstraintManager> localCMs = new LinkedList<Parameters.LocalConstraintManager>();
            Errors.Builder bb = new Errors.Builder();
            for (Field each : fsmFields) {
                FSMLevelsProvider fsmLevelsProvider = (FSMLevelsProvider)levelsProviders.get(each);
                TupleGeneratorFactory.validateFSMFactorField(bb, each);
                String fsmName = each.getName();
                FSM<?> fsm = TupleGeneratorFactory.createFSM(each, fsmLevelsProvider.getSwitchCoverage());
                fsms.put(fsmName, fsm);
                TupleGeneratorFactory.collectLocalConstraintManagers(localCMs, fsmName, fsm);
            }
            Errors errors = bb.build();
            Checks.checktest(errors.size() == 0, "Error(s) are found in test class.'%s' : %s", klazz.getCanonicalName(), errors);
            generator = new FSMTupleGenerator(b, fsms, localCMs);
            generator.init(Param.EMPTY_ARRAY);
        } else {
            generator = b.build();
        }
        return generator;
    }

    private static void collectLocalConstraintManagers(List<Parameters.LocalConstraintManager> localCMs, String fsmName, FSM fsm) {
        for (int i = 0; i < fsm.historyLength(); ++i) {
            for (Action eachAction : fsm.actions()) {
                Parameters parameters = eachAction.parameters();
                ConstraintManager baseLocalCM = parameters.getConstraintManager();
                if (ConstraintManager.DEFAULT_CONSTRAINT_MANAGER.equals(baseLocalCM)) continue;
                List<String> localPlainParameterNames = Utils.transform(parameters, new Utils.Form<Factor, String>(){

                    @Override
                    public String apply(Factor in) {
                        return Checks.checknotnull(in).name;
                    }
                });
                Parameters.LocalConstraintManager localCM = new Parameters.LocalConstraintManager(baseLocalCM, localPlainParameterNames, fsmName, i);
                localCMs.add(localCM);
            }
        }
    }

    private static List<Field> extractFSMFactorFields(Set<Field> factorFields) {
        LinkedList<Field> ret = new LinkedList<Field>();
        for (Field each : factorFields) {
            if (!FSMUtils.isStoryField(each)) continue;
            ret.add(each);
        }
        return ret;
    }

    private static FSM<?> createFSM(Field f, int switchCoverage) {
        Checks.checknotnull(f);
        Class clazz = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[1];
        return TupleGeneratorFactory.createFSM(f.getName(), clazz, switchCoverage + 1);
    }

    private static void validateFSMFactorField(Errors.Builder errors, Field f) {
        Type genericType;
        Checks.checknotnull(f);
        FactorField ann = f.getAnnotation(FactorField.class);
        Checks.checknotnull(ann);
        Checks.checkcond(ann.levelsProvider() != null);
        Class<? extends LevelsProvider> levelsProvider = ann.levelsProvider();
        Checks.checknotnull(levelsProvider);
        Checks.checkcond(FSMLevelsProvider.class.isAssignableFrom(levelsProvider), "'%s' must be a sub-class of '%s', but isn't", levelsProvider.getCanonicalName(), FSMLevelsProvider.class.getCanonicalName());
        if (!Story.class.equals(f.getType())) {
            errors.add("For FSM factor field (field annotated with '%s' whose levelsProvider is '%s') must be exactly '%s', but was '%s'", FactorField.class.getSimpleName(), FSMLevelsProvider.class.getSimpleName(), Story.class.getCanonicalName(), f.getType());
        }
        if (!((genericType = f.getGenericType()) instanceof ParameterizedType)) {
            errors.add("FSM factor field must have a parameterized type as its generic type. But '%s'(%s)'s generic type was '%s'", f.getName(), f.getDeclaringClass().getCanonicalName(), genericType != null ? genericType.getClass().getCanonicalName() : null);
        }
    }

    protected Factors loadFactors(Class<?> klass, Map<Field, LevelsProvider> providers) {
        Field[] fields = Utils.getAnnotatedFields(klass, FactorField.class);
        Factors.Builder factorsBuilder = new Factors.Builder();
        InvalidTestException invalidTestException = new InvalidTestException("One or more factors failed to be initialized.");
        for (Field f : fields) {
            try {
                FactorLoader factorLoader = new FactorLoader(f);
                Factor factor = factorLoader.getFactor();
                factorsBuilder.add(factor);
                providers.put(f, factorLoader.getLevelsProvider());
            }
            catch (InvalidTestException e) {
                invalidTestException.addChild(e);
            }
        }
        if (invalidTestException.hasChildren()) {
            invalidTestException.fillInStackTrace();
            throw invalidTestException;
        }
        Factors factors = factorsBuilder.build();
        return factors;
    }

    TupleGeneration getTupleGenerationAnnotation(AnnotatedElement annotatedElement) {
        TupleGeneration ret = annotatedElement.isAnnotationPresent(TupleGeneration.class) ? annotatedElement.getAnnotation(TupleGeneration.class) : new TupleGeneration(){

            @Override
            public Generator generator() {
                return (Generator)Utils.getDefaultValueOfAnnotation(TupleGeneration.class, "generator");
            }

            @Override
            public Constraint constraint() {
                return (Constraint)Utils.getDefaultValueOfAnnotation(TupleGeneration.class, "constraint");
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return TupleGeneration.class;
            }
        };
        return ret;
    }
}

