/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.ParamType;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.fsm.FSM;
import com.github.dakusui.jcunit.fsm.FSMConstraintManager;
import com.github.dakusui.jcunit.fsm.FSMFactors;
import com.github.dakusui.jcunit.fsm.Parameters;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.StateRouter;
import com.github.dakusui.jcunit.fsm.Story;
import com.github.dakusui.jcunit.generators.TupleGenerator;
import com.github.dakusui.jcunit.generators.TupleGeneratorBase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FSMTupleGenerator
extends TupleGeneratorBase {
    private final Map<String, FSM> fsms;
    private final TupleGenerator.Builder baseTupleGeneratorBuilder;
    private final List<Parameters.LocalConstraintManager> localCMs;
    private List<Tuple> tuples;

    public FSMTupleGenerator(TupleGenerator.Builder baseTG, Map<String, FSM> fsms, List<Parameters.LocalConstraintManager> localCMs) {
        this.fsms = Checks.checknotnull(fsms);
        this.baseTupleGeneratorBuilder = Checks.checknotnull(baseTG);
        this.localCMs = Collections.unmodifiableList(localCMs);
    }

    @Override
    protected long initializeTuples(Object[] params) {
        Factors baseFactors = this.baseTupleGeneratorBuilder.getFactors();
        FSMFactors fsmFactors = FSMTupleGenerator.buildFSMFactors(baseFactors, this.fsms);
        FSMConstraintManager fsmCM = new FSMConstraintManager(this.baseTupleGeneratorBuilder.getConstraintManager(), this.localCMs);
        fsmCM.setFactors(fsmFactors);
        this.tuples = Utils.dedup(this.generateTestCaseTuples(this.fsms, fsmFactors, fsmCM));
        Factors.Builder factorsRebuilder = new Factors.Builder();
        for (String eachFSMName : this.fsms.keySet()) {
            Factor.Builder b = new Factor.Builder(eachFSMName);
            for (Tuple eachTuple : this.tuples) {
                Story story = (Story)eachTuple.get(eachFSMName);
                if (b.hasLevel(story)) continue;
                b.addLevel(story);
            }
            factorsRebuilder.add(b.build());
        }
        for (Factor eachFactor : fsmFactors) {
            if (this.isFSMFactorName(eachFactor.name)) continue;
            factorsRebuilder.add(eachFactor);
        }
        super.setFactors(factorsRebuilder.build());
        super.setConstraintManager(ConstraintManager.DEFAULT_CONSTRAINT_MANAGER);
        return this.tuples.size();
    }

    private static FSMFactors buildFSMFactors(Factors baseFactors, Map<String, FSM> fsms) {
        FSMFactors.Builder b = new FSMFactors.Builder();
        for (Map.Entry<String, FSM> each : fsms.entrySet()) {
            b.addFSM(each.getKey(), each.getValue());
        }
        return b.setBaseFactors(baseFactors).build();
    }

    private List<Tuple> generateTestCaseTuples(Map<String, FSM> fsms, FSMFactors fsmFactors, ConstraintManager fsmCM) {
        Object cur;
        TupleGenerator flattenFSMTuples = this.generateFlattenFSMTestCaseTuples(fsmFactors, fsmCM);
        LinkedHashMap sequences = new LinkedHashMap();
        for (Tuple eachTuple : flattenFSMTuples) {
            for (Map.Entry<String, FSM> entry : fsms.entrySet()) {
                String fsmName = entry.getKey();
                ScenarioSequence main = new ScenarioSequence.BuilderFromTuple().setFSMFactors(fsmFactors).setTuple(eachTuple).setFSMName(fsmName).build();
                if (!sequences.containsKey(fsmName)) {
                    sequences.put(fsmName, new LinkedList());
                }
                ((List)sequences.get(fsmName)).add(main);
            }
        }
        LinkedHashMap<String, Object> stateRouters = new LinkedHashMap<String, Object>();
        for (Map.Entry each : sequences.entrySet()) {
            String fsmName = (String)each.getKey();
            cur = new StateRouter(fsms.get(fsmName), new StateRouter.EdgeLister((List)each.getValue()));
            stateRouters.put(fsmName, cur);
        }
        LinkedList<Tuple> ret = new LinkedList<Tuple>();
        for (Tuple eachTuple : flattenFSMTuples) {
            cur = new Tuple.Builder();
            for (Map.Entry<String, FSM> entry : this.fsms.entrySet()) {
                String fsmName = entry.getKey();
                ScenarioSequence main = new ScenarioSequence.BuilderFromTuple().setFSMFactors(fsmFactors).setTuple(eachTuple).setFSMName(fsmName).build();
                StateRouter router = (StateRouter)stateRouters.get(fsmName);
                Story story = main.state(0) != entry.getValue().initialState() ? new Story(fsmName, router.routeTo(main.state(0)), main) : new Story(fsmName, ScenarioSequence.EMPTY, main);
                ((Tuple.Builder)cur).put(fsmName, story);
            }
            for (String eachFactorName : eachTuple.keySet()) {
                if (this.isFSMFactorName(eachFactorName)) continue;
                Object v = eachTuple.get(eachFactorName);
                ((Tuple.Builder)cur).put(eachFactorName, v);
            }
            ret.add(((Tuple.Builder)cur).build());
        }
        return ret;
    }

    private boolean isFSMFactorName(String eachFactorName) {
        return Checks.checknotnull(eachFactorName.contains(":"));
    }

    private TupleGenerator generateFlattenFSMTestCaseTuples(FSMFactors fsmFactors, ConstraintManager fsmCM) {
        return new TupleGenerator.Builder(this.baseTupleGeneratorBuilder).setConstraintManager(fsmCM).setFactors(fsmFactors).build();
    }

    @Override
    public Tuple getTuple(int tupleId) {
        return this.tuples.get(tupleId);
    }

    @Override
    public ParamType[] parameterTypes() {
        return new ParamType[0];
    }
}

