/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.fsm.FSM;
import com.github.dakusui.jcunit.fsm.FSMUtils;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.SimpleFSM;
import com.github.dakusui.jcunit.fsm.State;
import com.github.dakusui.jcunit.fsm.StateChecker;
import com.github.dakusui.jcunit.fsm.Story;
import com.github.dakusui.jcunit.fsm.spec.FSMSpec;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class Expectation<SUT> {
    private final String fsmName;
    public final State<SUT> state;
    private final Type type;
    private final Checker checker;

    protected Expectation(String fsmName, Type type, State<SUT> state, Checker checker) {
        Checks.checknotnull(type);
        Checks.checknotnull(state);
        Checks.checknotnull(checker);
        this.fsmName = fsmName;
        this.type = type;
        this.state = state;
        this.checker = checker;
    }

    public <T> Result checkThrownException(T context, SUT sut, Throwable thrownException, ScenarioSequence.Observer observer) {
        Checks.checknotnull(sut);
        Checks.checknotnull(thrownException);
        Result.Builder b = new Result.Builder("Expectation was not satisfied");
        if (this.type != Type.EXCEPTION_THROWN) {
            b.addFailedReason(String.format("Exception was not expected to be thrown but %s was thrown. (%s)", thrownException.getClass().getSimpleName(), this.checker.format()), thrownException);
        }
        if (!this.checker.check(context, thrownException, observer)) {
            b.addFailedReason(String.format("'%s' is expected to be %s but '%s' was thrown. (%s)", new Object[]{this.checker.format(), this.type, thrownException, thrownException.getMessage()}), thrownException);
        }
        if (!this.state.check(sut)) {
            b.addFailedReason(String.format("'%s' is expected to be in '%s' state but not.", sut, this.state));
        }
        return b.build();
    }

    public <T> Result checkReturnedValue(T context, SUT sut, Object returnedValue, ScenarioSequence.Type type, ScenarioSequence.Observer observer) {
        Checks.checknotnull(sut);
        Result.Builder b = new Result.Builder("Expectation was not satisfied");
        if (this.type != Type.VALUE_RETURNED) {
            b.addFailedReason(String.format("Exception was expected not to be thrown but it was. (%s)", this.checker.format()));
        }
        if (this.checker.shouldBeCheckedFor(type) && !this.checker.check(context, returnedValue, observer)) {
            b.addFailedReason(String.format("'%s' is expected to be %s but '%s' was returned.", new Object[]{this.checker.format(), this.type, returnedValue}));
        }
        if (!this.state.check(sut)) {
            b.addFailedReason(String.format("FSM '%s' is expected to be in '%s' state but not.(actual='%s')", this.fsmName, this.state, sut));
        }
        return b.build();
    }

    public String toString() {
        if (this.type == Type.EXCEPTION_THROWN) {
            return String.format("status of '%s' is '%s' and %s is thrown", this.fsmName, this.state, this.checker.format());
        }
        return String.format("status of '%s' is '%s' and %s is returned", this.fsmName, this.state, this.checker.format());
    }

    public static interface Checker {
        public boolean shouldBeCheckedFor(ScenarioSequence.Type var1);

        public <T> boolean check(T var1, Object var2, ScenarioSequence.Observer var3);

        public String format();

        public static class FSM
        extends Base
        implements Checker {
            String fsmName;

            public FSM(String fsmName) {
                Checks.checknotnull(fsmName);
                this.fsmName = fsmName;
            }

            @Override
            public <T> boolean check(T context, Object item, ScenarioSequence.Observer observer) {
                Checks.checknotnull(context);
                Story<?, ?> story = FSM.lookupStory(context, this.fsmName);
                if (!Checks.checknotnull(story).isPerformed()) {
                    Story.Performer.Default.INSTANCE.perform(story, context, item, FSMUtils.Synchronizer.DUMMY, observer.createChild(this.fsmName));
                }
                return true;
            }

            private static Story<?, ?> lookupStory(Object context, String fsmName) {
                Checks.checknotnull(context);
                Checks.checknotnull(fsmName);
                try {
                    Field f = context.getClass().getField(fsmName);
                    return (Story)Checks.checknotnull(f).get(context);
                }
                catch (NoSuchFieldException e) {
                    Checks.rethrow(e);
                }
                catch (IllegalAccessException e) {
                    Checks.rethrow(e);
                }
                Checks.checkcond(false, "This path shouldn't be executed.", new Object[0]);
                assert (false);
                return null;
            }

            @Override
            public boolean shouldBeCheckedFor(ScenarioSequence.Type type) {
                return type == ScenarioSequence.Type.main;
            }

            @Override
            public String format() {
                return String.format("FSM:%s", this.fsmName);
            }
        }

        public static class MatcherBased
        extends Base
        implements Checker {
            private final Matcher matcher;

            public MatcherBased(Matcher matcher) {
                this.matcher = Checks.checknotnull(matcher);
            }

            @Override
            public <T> boolean check(T context, Object item, ScenarioSequence.Observer observer) {
                return this.matcher.matches(item);
            }

            @Override
            public String format() {
                return this.matcher.toString();
            }
        }

        public static abstract class Base
        implements Checker {
            @Override
            public boolean shouldBeCheckedFor(ScenarioSequence.Type type) {
                return true;
            }
        }
    }

    public static class Result
    extends AssertionError {
        private final List<Reason> failedReasons;

        public Result(String message, List<Reason> failedReasons) {
            super((Object)message);
            this.failedReasons = Collections.unmodifiableList(failedReasons);
        }

        public boolean isSuccessful() {
            return this.failedReasons.isEmpty();
        }

        public void throwIfFailed() {
            if (!this.isSuccessful()) {
                this.fillInStackTrace();
                throw this;
            }
        }

        public String getMessage() {
            String ret = super.getMessage();
            if (!this.failedReasons.isEmpty()) {
                ret = ret + String.format(": [%s]", Utils.join(",", this.failedReasons.toArray()));
            }
            return ret;
        }

        public void printStackTrace(PrintStream ps) {
            Checks.checknotnull(ps);
            for (Reason each : this.failedReasons) {
                ps.println(each.message);
                if (each.t == null) continue;
                each.t.printStackTrace(ps);
            }
        }

        public void printStackTrace(PrintWriter pw) {
            Checks.checknotnull(pw);
            for (Reason each : this.failedReasons) {
                pw.println(each.message);
                if (each.t == null) continue;
                each.t.printStackTrace(pw);
            }
        }

        static class Builder {
            private List<Reason> failures = new LinkedList<Reason>();
            private String message;

            Builder(String message) {
                this.message = message;
            }

            Builder addFailedReason(String message) {
                Checks.checknotnull(message);
                return this.addFailedReason(message, null);
            }

            Builder addFailedReason(String message, Throwable t) {
                this.failures.add(new Reason(message, t));
                return this;
            }

            Result build() {
                return new Result(this.message, this.failures);
            }
        }
    }

    static class Reason {
        private final String message;
        private final Throwable t;

        Reason(String message, Throwable t) {
            this.message = message;
            this.t = t;
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Type {
        EXCEPTION_THROWN{

            public String toString() {
                return "thrown";
            }
        }
        ,
        VALUE_RETURNED{

            public String toString() {
                return "returned";
            }
        };

    }

    public static class Builder<SUT> {
        private final FSM<SUT> fsm;
        private final String fsmName;
        private Type type;
        private Checker checker;
        private State<SUT> state;

        Builder(String fsmName, FSM<SUT> fsm) {
            this.fsm = fsm;
            this.fsmName = fsmName;
        }

        public Builder<SUT> invalid() {
            return this.invalid(IllegalArgumentException.class);
        }

        public Builder<SUT> invalid(Class<? extends Throwable> klass) {
            Checks.checknotnull(klass);
            return this.invalid(FSMSpec.VOID, klass);
        }

        public Builder<SUT> invalid(FSMSpec<SUT> state, Class<? extends Throwable> klass) {
            Checks.checknotnull(state);
            this.type = Type.EXCEPTION_THROWN;
            this.state = this.chooseState(state);
            this.checker = new Checker.MatcherBased(CoreMatchers.instanceOf(klass));
            return this;
        }

        public Builder<SUT> valid(FSMSpec<SUT> state) {
            return this.valid(state, CoreMatchers.anything());
        }

        public Builder<SUT> valid(FSMSpec<SUT> state, Object returnedValue) {
            return this.valid(state, CoreMatchers.is((Object)returnedValue));
        }

        public Builder<SUT> valid(FSMSpec<SUT> state, Matcher matcher) {
            Checks.checknotnull(matcher);
            return this.valid(state, new Checker.MatcherBased(matcher));
        }

        public Builder<SUT> valid(FSMSpec<SUT> state, Checker checker) {
            Checks.checknotnull(state);
            Checks.checknotnull(checker);
            this.type = Type.VALUE_RETURNED;
            this.state = this.chooseState(state);
            this.checker = checker;
            return this;
        }

        private State<SUT> chooseState(StateChecker<SUT> stateChecker) {
            Checks.checknotnull(this.fsm);
            Checks.checknotnull(stateChecker);
            if (stateChecker == FSMSpec.VOID) {
                return State.VOID;
            }
            for (State<SUT> each : this.fsm.states()) {
                if (((SimpleFSM.SimpleFSMState)each).stateSpec != stateChecker) continue;
                return each;
            }
            Checks.checkcond(false, "No state for '%s' was found.", stateChecker);
            return null;
        }

        public Expectation<SUT> build() {
            return new Expectation<SUT>(this.fsmName, this.type, this.state, this.checker);
        }
    }
}

