/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core.factor;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FactorField;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.LevelsProviderBase;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLevelsProvider
extends LevelsProviderBase<Object> {
    private static final Map<Class<?>, Method> methodNameMappings = new HashMap();
    private Object values;
    private int size;

    @Override
    protected void init(Field targetField, FactorField annotation, Object[] parameters) {
        try {
            Method m = this.chooseMethodForThisField(targetField, annotation, this.errors);
            if (m == null) {
                Checks.checkcond(!this.errors.isEmpty());
                return;
            }
            Object values = m.invoke((Object)annotation, new Object[0]);
            Checks.checknotnull(values);
            if (values.getClass().isArray()) {
                this.values = values;
            } else if (Enum.class.isAssignableFrom((Class)values)) {
                this.values = targetField.getType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
            } else {
                throw new RuntimeException();
            }
            this.size = Array.getLength(this.values);
            Class<?> compType = this.values.getClass().getComponentType();
            if ((String.class.equals(compType) || Enum.class.isAssignableFrom(compType)) && annotation.includeNull()) {
                Object work = Array.newInstance(compType, this.size + 1);
                System.arraycopy(this.values, 0, work, 0, this.size);
                Array.set(work, this.size, null);
                this.values = work;
                ++this.size;
            }
            if (!targetField.getType().isAssignableFrom(compType)) {
                this.errors.add(String.format("Incompatible method '%s' is specified for field '%s' (%s)", m.getName(), targetField.getName(), targetField.getType().getCanonicalName()));
            }
            return;
        }
        catch (IllegalAccessException e) {
            Checks.rethrow(e);
        }
        catch (InvocationTargetException e) {
            Checks.rethrow(e);
        }
        catch (NoSuchMethodException e) {
            Checks.rethrow(e);
        }
        throw new RuntimeException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int index) {
        return Array.get(this.values, index);
    }

    private Method chooseMethodForThisField(Field targetField, FactorField ann, List<String> errors) {
        Method[] overridingLevelsMethods = this.getOverridingLevelsMethods(ann);
        Class<Object> fieldType = targetField.getType();
        if (overridingLevelsMethods.length == 0) {
            if (Enum.class.isAssignableFrom(fieldType)) {
                fieldType = Enum.class;
            }
            if (!methodNameMappings.containsKey(fieldType)) {
                errors.add(String.format("For the field '%s', 'levelsProvider' needs to be provided since there is no pre-defined xyzLevels method for it.", targetField));
            }
            return methodNameMappings.get(fieldType);
        }
        if (overridingLevelsMethods.length > 1) {
            errors.add(String.format("You can give at most one explicit value to FactorField annotation, but %d were given. [%s]", overridingLevelsMethods.length, Utils.join(",", new Utils.Formatter<Method>(){

                @Override
                public String format(Method m) {
                    return m.getName();
                }
            }, overridingLevelsMethods)));
            return null;
        }
        return overridingLevelsMethods[0];
    }

    private Method[] getOverridingLevelsMethods(FactorField factorFieldAnnotation) {
        Method[] methods = FactorField.class.getDeclaredMethods();
        ArrayList<Method> work = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            if (!m.getName().endsWith("Levels") && !"levelsProvider".equals(m.getName())) continue;
            try {
                if (DefaultLevelsProvider.areSame(m.getDefaultValue(), m.invoke((Object)factorFieldAnnotation, new Object[0]))) continue;
                work.add(m);
            }
            catch (IllegalAccessException e) {
                Checks.rethrow(e, "Something went wrong:'%s'", e.getMessage());
            }
            catch (InvocationTargetException e) {
                Checks.rethrow(e, "Something went wrong:%s", e.getMessage());
            }
        }
        return work.toArray(new Method[work.size()]);
    }

    private static Method getLevelsMethod(String methodName) {
        try {
            return FactorField.class.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Checks.rethrow(e, "Something went wrong. A method '%s' should be found in @FactorField", methodName);
            throw new RuntimeException();
        }
    }

    private static boolean areSame(Object arr1, Object arr2) {
        if (arr1 == null || arr2 == null) {
            return arr1 == arr2;
        }
        if (!arr1.getClass().isArray()) {
            return DefaultLevelsProvider.eq(arr1, arr2);
        }
        if (arr2.getClass().isArray() && Array.getLength(arr1) == Array.getLength(arr2)) {
            int len = Array.getLength(arr1);
            for (int i = 0; i < len; ++i) {
                if (DefaultLevelsProvider.eq(Array.get(arr1, i), Array.get(arr2, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean eq(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    static {
        methodNameMappings.put(Boolean.TYPE, DefaultLevelsProvider.getLevelsMethod("booleanLevels"));
        methodNameMappings.put(Boolean.class, DefaultLevelsProvider.getLevelsMethod("booleanLevels"));
        methodNameMappings.put(Byte.TYPE, DefaultLevelsProvider.getLevelsMethod("byteLevels"));
        methodNameMappings.put(Byte.class, DefaultLevelsProvider.getLevelsMethod("byteLevels"));
        methodNameMappings.put(Character.TYPE, DefaultLevelsProvider.getLevelsMethod("charLevels"));
        methodNameMappings.put(Character.class, DefaultLevelsProvider.getLevelsMethod("charLevels"));
        methodNameMappings.put(Short.TYPE, DefaultLevelsProvider.getLevelsMethod("shortLevels"));
        methodNameMappings.put(Short.class, DefaultLevelsProvider.getLevelsMethod("shortLevels"));
        methodNameMappings.put(Integer.TYPE, DefaultLevelsProvider.getLevelsMethod("intLevels"));
        methodNameMappings.put(Integer.class, DefaultLevelsProvider.getLevelsMethod("intLevels"));
        methodNameMappings.put(Long.TYPE, DefaultLevelsProvider.getLevelsMethod("longLevels"));
        methodNameMappings.put(Long.class, DefaultLevelsProvider.getLevelsMethod("longLevels"));
        methodNameMappings.put(Float.TYPE, DefaultLevelsProvider.getLevelsMethod("floatLevels"));
        methodNameMappings.put(Float.class, DefaultLevelsProvider.getLevelsMethod("floatLevels"));
        methodNameMappings.put(Double.TYPE, DefaultLevelsProvider.getLevelsMethod("doubleLevels"));
        methodNameMappings.put(Double.class, DefaultLevelsProvider.getLevelsMethod("doubleLevels"));
        methodNameMappings.put(String.class, DefaultLevelsProvider.getLevelsMethod("stringLevels"));
        methodNameMappings.put(Enum.class, DefaultLevelsProvider.getLevelsMethod("enumLevels"));
    }
}

