/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FactorField;
import com.github.dakusui.jcunit.core.factor.LevelsProvider;
import com.github.dakusui.jcunit.core.factor.LevelsProviderFactory;
import com.github.dakusui.jcunit.exceptions.JCUnitException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Utils {
    public static Field getField(Object obj, String fieldName, Class<? extends Annotation> ... expectedAnnotations) {
        Checks.checknotnull(obj);
        Checks.checknotnull(fieldName);
        Class<?> clazz = obj.getClass();
        return Utils.getFieldFromClass(clazz, fieldName, expectedAnnotations);
    }

    public static Field getFieldFromClass(Class<?> clazz, String fieldName, Class<? extends Annotation> ... expectedAnnotations) {
        Field ret;
        Checks.checknotnull(clazz);
        Checks.checknotnull(fieldName);
        try {
            ret = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            String msg = String.format("Field '%s' isn't defined in class '%s', not public, or not annotated.", fieldName, clazz.getCanonicalName());
            throw new IllegalArgumentException(msg, e);
        }
        if (expectedAnnotations.length > 0) {
            for (Class<? extends Annotation> expectedAnnotation : expectedAnnotations) {
                Checks.checknotnull(expectedAnnotation);
                if (!ret.isAnnotationPresent(expectedAnnotation)) continue;
                return ret;
            }
            Checks.checkparam(false, String.format("Field '%s' is found in '%s, but not annotated with none of [%s]", fieldName, clazz, Utils.join(",", new Formatter<Class<? extends Annotation>>(){

                @Override
                public String format(Class<? extends Annotation> elem) {
                    return elem.getSimpleName();
                }
            }, expectedAnnotations)), new Object[0]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object obj, Field f, Object value) {
        Checks.checknotnull(obj);
        Checks.checknotnull(f);
        boolean accessible = f.isAccessible();
        try {
            f.setAccessible(true);
            f.set(obj, value);
        }
        catch (IllegalAccessException e) {
            Checks.rethrow(e, "Something went wrong.", new Object[0]);
        }
        finally {
            f.setAccessible(accessible);
        }
    }

    public static <T> String join(String sep, Formatter<T> formatter, T ... elems) {
        Checks.checknotnull(sep);
        StringBuilder b = new StringBuilder();
        boolean firstOne = true;
        for (T s : elems) {
            if (!firstOne) {
                b.append(sep);
            }
            b.append(formatter.format(s));
            firstOne = false;
        }
        return b.toString();
    }

    public static String join(String sep, Object ... elems) {
        return Utils.join(sep, Formatter.INSTANCE, elems);
    }

    public static Field[] getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annClass) {
        Field[] fields = clazz.getFields();
        ArrayList<Field> ret = new ArrayList<Field>(fields.length);
        for (Field f : fields) {
            if (f.getAnnotation(annClass) == null) continue;
            ret.add(f);
        }
        Collections.sort(ret, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return ret.toArray(new Field[ret.size()]);
    }

    public static <T> T invokeMethod(Object on, Method m, Object ... parameters) {
        try {
            return (T)m.invoke(on, parameters);
        }
        catch (IllegalAccessException e) {
            Checks.rethrow(e);
        }
        catch (InvocationTargetException e) {
            Checks.rethrow(e.getTargetException());
        }
        Checks.checkcond(false, "Something went wrong.", new Object[0]);
        return null;
    }

    public static <T> T createNewInstanceUsingNoParameterConstructor(Class<? extends T> klazz) {
        T ret = null;
        try {
            ret = klazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            Checks.rethrow(e, "'%s' is a class that cannot be instantiated directly.", klazz.getCanonicalName());
        }
        catch (IllegalAccessException e) {
            Checks.rethrow(e, "Failed to instantiate '%s'. The constructor with no parameter is not open enough.", klazz.getCanonicalName());
        }
        catch (InvocationTargetException e) {
            Checks.rethrow(e.getTargetException(), "Failed to instantiate '%s'. An exception was thrown during instantiation.", klazz.getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            Checks.rethrow(e, "Failed to instantiate '%s'. A constructor with no parameter is not found.", klazz.getCanonicalName());
        }
        Checks.checknotnull(ret);
        return ret;
    }

    public static <T> T getDefaultValueOfAnnotation(Class<? extends Annotation> klazz, String method) {
        Checks.checknotnull(klazz);
        Checks.checknotnull(method);
        try {
            return (T)klazz.getDeclaredMethod(method, new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException e) {
            Checks.rethrow(e);
            Checks.checkcond(false, "Something went wrong. This line shouldn't be executed.", new Object[0]);
            return null;
        }
    }

    public static boolean eq(Object v, Object o) {
        if (v == null) {
            return o == null;
        }
        return v.equals(o);
    }

    public static boolean createFile(File file) {
        Checks.checknotnull(file);
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            Checks.rethrow(e);
            return false;
        }
    }

    public static BufferedOutputStream openForWrite(File f) {
        BufferedOutputStream ret = null;
        try {
            ret = new BufferedOutputStream(new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            Checks.rethrow(e);
        }
        return ret;
    }

    public static BufferedInputStream openForRead(File f) {
        Checks.checknotnull(f);
        BufferedInputStream ret = null;
        try {
            ret = new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            Checks.rethrow(e, "File not found: '%s'", f.getAbsolutePath());
        }
        return ret;
    }

    public static void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            Checks.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Object obj, File to) {
        BufferedOutputStream bos = Utils.openForWrite(to);
        try {
            Utils.save(obj, bos);
        }
        finally {
            Utils.close(bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Object obj, OutputStream os) {
        Checks.checknotnull(obj);
        Checks.checknotnull(os);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            try {
                oos.writeObject(obj);
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            Checks.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(File f) {
        Checks.checknotnull(f);
        BufferedInputStream bis = Utils.openForRead(f);
        try {
            Object object = Utils.load(bis);
            return object;
        }
        finally {
            Utils.close(bis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(InputStream is) {
        Checks.checknotnull(is);
        Object ret = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                ret = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                Checks.rethrow(e);
            }
            finally {
                ois.close();
            }
        }
        catch (IOException e) {
            Checks.rethrow(e);
        }
        return ret;
    }

    public static boolean deleteRecursive(File path) {
        Checks.checknotnull(path);
        if (!path.exists()) {
            throw new JCUnitException(String.format("Path '%s' was not found.", path.getAbsolutePath()), null);
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && Utils.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    public static <T> List<T> dedup(Iterable<T> in) {
        LinkedList<T> ret = new LinkedList<T>();
        for (T each : Checks.checknotnull(in)) {
            if (ret.contains(each)) continue;
            ret.add(each);
        }
        return ret;
    }

    public static <T> List<T> singleton(List<T> in) {
        Checks.checknotnull(in);
        ArrayList<T> ret = new ArrayList<T>(in.size());
        for (T each : in) {
            if (ret.contains(each)) continue;
            ret.add(each);
        }
        return ret;
    }

    public static <I, O> List<O> transform(Iterable<I> in, Form<I, O> form) {
        ArrayList<O> ret = new ArrayList<O>();
        for (I each : in) {
            ret.add(form.apply(each));
        }
        return ret;
    }

    public static <K, V> Map<K, V> toMap(List<V> in, Form<V, K> form) {
        Checks.checknotnull(in);
        Checks.checknotnull(form);
        LinkedHashMap<K, V> ret = new LinkedHashMap<K, V>();
        for (V each : in) {
            ret.put(form.apply(each), each);
        }
        return ret;
    }

    public static <V> List filter(List<V> unfiltered, Predicate<V> predicate) {
        Checks.checknotnull(unfiltered);
        Checks.checknotnull(predicate);
        LinkedList<V> ret = new LinkedList<V>();
        for (V each : unfiltered) {
            if (!predicate.apply(each)) continue;
            ret.add(each);
        }
        return ret;
    }

    public static <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static ValidationResult validateFactorField(Field f) {
        ValidationResult ret;
        Checks.checknotnull(f);
        FactorField ann = f.getAnnotation(FactorField.class);
        Checks.checknotnull(ann);
        LinkedList<String> errors = new LinkedList<String>();
        LevelsProvider levelsProvider = LevelsProviderFactory.INSTANCE.createLevelsProvider(f, ann, errors);
        errors.addAll(levelsProvider.getErrorsOnInitialization());
        if (errors.isEmpty()) {
            levelsProvider.setAnnotation(ann);
            levelsProvider.setTargetField(f);
            levelsProvider.init(ann.providerParams());
            ret = new ValidationResult(true, levelsProvider, null);
        } else {
            ret = new ValidationResult(false, null, Utils.join("; ", errors.toArray()));
        }
        return ret;
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String errMessage;
        private final LevelsProvider<?> levelsProvider;

        public ValidationResult(boolean valid, LevelsProvider<?> levelsProvider, String errorMessage) {
            if (valid) {
                Checks.checknotnull(levelsProvider);
            } else {
                Checks.checknotnull(errorMessage);
            }
            this.valid = valid;
            this.levelsProvider = levelsProvider;
            this.errMessage = errorMessage;
        }

        public LevelsProvider<?> getLevelsProvider() {
            return this.levelsProvider;
        }

        public void check() {
            Checks.checktest(this.valid, this.errMessage, new Object[0]);
        }
    }

    public static interface Predicate<I> {
        public boolean apply(I var1);
    }

    public static interface Form<I, O> {
        public O apply(I var1);
    }

    public static interface Formatter<T> {
        public static final Formatter INSTANCE = new Formatter<Object>(){

            @Override
            public String format(Object elem) {
                if (elem == null) {
                    return null;
                }
                return elem.toString();
            }
        };

        public String format(T var1);
    }
}

