/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FrameworkMethodUtils;
import com.github.dakusui.jcunit.core.JCUnitRunner;
import com.github.dakusui.jcunit.core.TestCaseUtils;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.generators.TupleGenerator;
import com.github.dakusui.jcunit.generators.TupleGeneratorFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class JCUnit
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public JCUnit(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        LinkedList<String> errors = new LinkedList<String>();
        List<FrameworkMethod> preconditionMethods = this.getFrameworkMethods(FrameworkMethodUtils.FrameworkMethodRetriever.PRECONDITION);
        for (FrameworkMethod each : preconditionMethods) {
            FrameworkMethodUtils.validateFrameworkMethod(klass, each, FrameworkMethodUtils.FrameworkMethodValidator.PRECONDITIONMETHOD_VALIDATOR, errors);
        }
        List<FrameworkMethod> customTestCaseMethods = this.getFrameworkMethods(FrameworkMethodUtils.FrameworkMethodRetriever.CUSTOM_TESTCASES);
        for (FrameworkMethod each : customTestCaseMethods) {
            FrameworkMethodUtils.validateFrameworkMethod(klass, each, FrameworkMethodUtils.FrameworkMethodValidator.CUSTOMTESTCASEMETHOD_VALIDATOR, errors);
        }
        Checks.checkenv(errors.isEmpty(), "Errors are found in test class '%s':%s", this.getTestClass().getJavaClass().getCanonicalName(), errors);
        TupleGenerator tupleGenerator = this.getTupleGeneratorFactory().createTupleGeneratorForClass(klass);
        Factors factors = tupleGenerator.getFactors();
        int id = (int)tupleGenerator.firstId();
        while (id >= 0) {
            Tuple testCase = tupleGenerator.get(id);
            if (this.shouldPerform(testCase, preconditionMethods)) {
                this.runners.add((Runner)this.createRunner(id, factors, TestCaseType.Generated, testCase));
            }
            id = (int)tupleGenerator.nextId(id);
        }
        id = (int)tupleGenerator.size();
        ConstraintManager cm = tupleGenerator.getConstraintManager();
        List<Tuple> violations = cm.getViolations();
        id = this.registerTestCases(id, factors, violations, TestCaseType.Violation, preconditionMethods);
        this.registerTestCases(id, factors, this.invokeCustomTestCasesMethod(customTestCaseMethods), TestCaseType.Custom, preconditionMethods);
        Checks.checkenv(this.runners.size() > 0, "No test to be run was found.", new Object[0]);
    }

    protected TupleGeneratorFactory getTupleGeneratorFactory() {
        return TupleGeneratorFactory.INSTANCE;
    }

    static Object createTestObject(TestClass testClass, Tuple testCase) {
        return TestCaseUtils.toTestObject(testClass.getJavaClass(), testCase);
    }

    private boolean shouldPerform(Tuple testCase, List<FrameworkMethod> preconditionMethods) {
        if (preconditionMethods.isEmpty()) {
            return true;
        }
        for (FrameworkMethod m : preconditionMethods) {
            try {
                Object testObject = JCUnit.createTestObject(this.getTestClass(), testCase);
                if (!((Boolean)m.invokeExplosively(testObject, new Object[0])).booleanValue()) continue;
                return true;
            }
            catch (Throwable throwable) {
                Checks.rethrow(throwable, "Failed to execute ", new Object[0]);
            }
        }
        return false;
    }

    private int registerTestCases(int id, Factors factors, Iterable<Tuple> testCases, TestCaseType testCaseType, List<FrameworkMethod> preconditionMethods) throws Throwable {
        for (Tuple testCase : testCases) {
            if (this.shouldPerform(testCase, preconditionMethods)) {
                this.runners.add((Runner)this.createRunner(id, factors, testCaseType, testCase));
            }
            ++id;
        }
        return id;
    }

    protected JCUnitRunner createRunner(int id, Factors factors, TestCaseType testCaseType, Tuple testCase) throws InitializationError {
        return new JCUnitRunner(this.getTestClass().getJavaClass(), id, testCaseType, factors, testCase);
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Tuple> invokeCustomTestCasesMethod(List<FrameworkMethod> customTestCasesMethods) {
        LinkedList<Tuple> ret = new LinkedList<Tuple>();
        try {
            for (FrameworkMethod each : customTestCasesMethods) {
                Object r = each.invokeExplosively(null, new Object[0]);
                if (r instanceof Tuple) {
                    ret.add((Tuple)r);
                    continue;
                }
                if (r instanceof Iterable) {
                    for (Object o : (Iterable)r) {
                        if (o == null) {
                            Checks.checkenv(false, "Returned value of '%s' must not contain null.", each.getName());
                        }
                        if (o instanceof Tuple) {
                            ret.add((Tuple)o);
                            continue;
                        }
                        if (this.getTestClass().getJavaClass().isAssignableFrom(o.getClass())) {
                            ret.add(TestCaseUtils.toTestCase(o));
                            continue;
                        }
                        Checks.checkenv(false, "Returned value of '%s' must contain only Tuple or test objects.", each.getName());
                    }
                    continue;
                }
                Checks.checkcond(false);
            }
        }
        catch (Throwable throwable) {
            Checks.rethrow(throwable, "Failed to execute '%s'.: (%s)", throwable.getMessage());
        }
        return ret;
    }

    private List<FrameworkMethod> getFrameworkMethods(FrameworkMethodUtils.FrameworkMethodRetriever retriever) {
        return retriever.getMethods(this.getTestClass().getJavaClass());
    }

    public static class InternalAnnotation
    implements Annotation {
        private final TestCaseType type;
        private final int id;
        private Factors factors;
        private Tuple testCase;

        public InternalAnnotation(TestCaseType type, int id, Factors factors, Tuple testCase) {
            Checks.checknotnull(type);
            this.id = id;
            this.type = type;
            this.factors = factors;
            this.testCase = testCase;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }

        public int getId() {
            return this.id;
        }

        public TestCaseType getTestCaseType() {
            return this.type;
        }

        public Tuple getTestCase() {
            return this.testCase;
        }

        public Factors getFactors() {
            return this.factors;
        }
    }

    public static enum TestCaseType {
        Custom,
        Generated,
        Violation;

    }
}

