/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.CustomTestCases;
import com.github.dakusui.jcunit.core.Precondition;
import com.github.dakusui.jcunit.core.When;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.fsm.FSMUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class FrameworkMethodUtils {
    private static FrameworkMethod getFrameworkMethodByName(Class<?> testClass, String methodName) {
        Method foundMethod = null;
        for (Method m : testClass.getDeclaredMethods()) {
            if (!methodName.equals(m.getName())) continue;
            if (foundMethod != null) {
                return new NotFoundMethod(methodName);
            }
            foundMethod = m;
        }
        if (foundMethod == null) {
            return new NotFoundMethod(methodName);
        }
        return new FrameworkMethod(foundMethod);
    }

    private static void validatePreconditionFrameworkMethod(Class<?> testClass, FrameworkMethod method, List<String> errors) {
        Class<?>[] parameterTypes;
        if (!method.isPublic()) {
            errors.add(String.format("The method '%s' must be public. (in %s)", method.getName(), testClass.getCanonicalName()));
        }
        if (method.isStatic()) {
            errors.add(String.format("The method '%s' must not be static. (in %s)", method.getName(), testClass.getCanonicalName()));
        }
        if (!Boolean.TYPE.equals(method.getReturnType())) {
            errors.add(String.format("The method '%s' must return a boolean value, but '%s' is returned. (in %s)", method.getName(), method.getReturnType().getName(), testClass.getCanonicalName()));
        }
        if ((parameterTypes = method.getMethod().getParameterTypes()).length != 0) {
            errors.add(String.format("The method '%s' must not have any parameter. (in %s)", method.getName(), testClass.getCanonicalName()));
        }
    }

    public static void validateFrameworkMethod(Class<?> testClass, FrameworkMethod method, FrameworkMethodValidator validator, List<String> errors) {
        Checks.checknotnull(testClass);
        Checks.checknotnull(method);
        Checks.checknotnull(validator);
        Checks.checknotnull(errors);
        if (method instanceof CompositeFrameworkMethod) {
            for (FrameworkMethod each : ((CompositeFrameworkMethod)method).methods) {
                FrameworkMethodUtils.validateFrameworkMethod(testClass, each, validator, errors);
            }
        } else if (method instanceof NotFoundMethod) {
            errors.add(String.format("The method '%s' is not found or not unique in a class '%s'", method.getName(), testClass.getCanonicalName()));
        } else {
            validator.validate(testClass, method, errors);
        }
    }

    public static String getPreconditionMethodNameFor(When ann) {
        Checks.checknotnull(ann);
        StringBuilder b = new StringBuilder();
        String[] values = ann.value();
        if (values.length > 1) {
            b.append('(');
        }
        boolean firstTime = true;
        for (String each : values) {
            if (!firstTime) {
                b.append("||");
            }
            b.append(FrameworkMethodUtils.normalize(each));
            firstTime = false;
        }
        if (values.length > 1) {
            b.append(')');
        }
        return b.toString();
    }

    private static String normalize(String term) {
        StringBuilder b = new StringBuilder();
        String[] tokens = term.replace(" ", "").split("&&");
        if (tokens.length > 1) {
            b.append('(');
        }
        boolean firstTime = true;
        for (String each : tokens) {
            if (!firstTime) {
                b.append("&&");
            }
            b.append(each);
            firstTime = false;
        }
        if (tokens.length > 1) {
            b.append(')');
        }
        return b.toString();
    }

    static class NotFoundMethod
    extends JCUnitFrameworkMethod {
        private final String methodName;

        public NotFoundMethod(String methodName) {
            super(DUMMY_METHOD);
            this.methodName = methodName;
        }

        @Override
        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.methodName;
        }
    }

    static class CompositeFrameworkMethod
    extends JCUnitFrameworkMethod {
        private final Mode mode;
        private final List<FrameworkMethod> methods;

        CompositeFrameworkMethod(Mode mode, List<FrameworkMethod> methods) {
            super(DUMMY_METHOD);
            Checks.checknotnull(methods);
            Checks.checknotnull(mode, "Mode isn't set yet.", new Object[0]);
            this.methods = methods;
            this.mode = mode;
        }

        @Override
        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            if (this.mode == Mode.And) {
                boolean ret = true;
                for (FrameworkMethod each : this.methods) {
                    ret &= ((Boolean)each.invokeExplosively(target, params)).booleanValue();
                }
                return ret;
            }
            if (this.mode == Mode.Or) {
                boolean ret = false;
                for (FrameworkMethod each : this.methods) {
                    FSMUtils.resetStories(target);
                    ret |= ((Boolean)each.invokeExplosively(target, params)).booleanValue();
                }
                return ret;
            }
            assert (false);
            return null;
        }

        @Override
        public String getName() {
            StringBuilder b = new StringBuilder();
            if (this.methods.size() > 1) {
                b.append("(");
            }
            boolean firstTime = true;
            for (FrameworkMethod each : this.methods) {
                if (!firstTime) {
                    b.append((Object)this.mode);
                }
                b.append(each.getName());
                firstTime = false;
            }
            if (this.methods.size() > 1) {
                b.append(")");
            }
            return b.toString();
        }

        public static boolean dummyMethod() {
            return true;
        }

        static enum Mode {
            And{

                public String toString() {
                    return "&&";
                }
            }
            ,
            Or{

                public String toString() {
                    return "||";
                }
            };

        }

        static class Builder {
            private List<FrameworkMethod> methods = new LinkedList<FrameworkMethod>();
            Mode mode = null;

            public Builder setMode(Mode mode) {
                this.mode = mode;
                return this;
            }

            public Builder addMethod(boolean negate, FrameworkMethod method) {
                FrameworkMethod m = negate ? new NegatedFrameworkMethod(method) : method;
                this.methods.add(m);
                return this;
            }

            public CompositeFrameworkMethod build() {
                return new CompositeFrameworkMethod(this.mode, this.methods);
            }
        }
    }

    static class NegatedFrameworkMethod
    extends JCUnitFrameworkMethod {
        private final FrameworkMethod enclosedMethod;

        public NegatedFrameworkMethod(FrameworkMethod method) {
            super(method.getMethod());
            this.enclosedMethod = method;
        }

        @Override
        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            return (Boolean)this.invokeExplosivelyInSuper(target, params) == false;
        }

        @Override
        public String getName() {
            return String.format("!%s", this.enclosedMethod.getName());
        }
    }

    static abstract class JCUnitFrameworkMethod
    extends FrameworkMethod {
        public static final Method DUMMY_METHOD;

        public JCUnitFrameworkMethod(Method method) {
            super(method);
        }

        public abstract Object invokeExplosively(Object var1, Object ... var2) throws Throwable;

        public abstract String getName();

        protected Object invokeExplosivelyInSuper(Object target, Object ... params) throws Throwable {
            return super.invokeExplosively(target, params);
        }

        static {
            try {
                DUMMY_METHOD = CompositeFrameworkMethod.class.getMethod("dummyMethod", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface FrameworkMethodRetriever {
        public static final FrameworkMethodRetriever CUSTOM_TESTCASES = new FrameworkMethodRetrieverBase(){

            @Override
            protected Class<? extends Annotation> getAnnotation() {
                return CustomTestCases.class;
            }
        };
        public static final FrameworkMethodRetriever PRECONDITION = new FrameworkMethodRetrieverBase(){

            @Override
            protected Class<? extends Annotation> getAnnotation() {
                return Precondition.class;
            }
        };
        public static final FrameworkMethodRetriever REFERENCED_BY_WHEN = new FrameworkMethodRetrieverBase(){

            @Override
            protected Class<? extends Annotation> getAnnotation() {
                return When.class;
            }

            @Override
            public List<FrameworkMethod> getMethods(Class<?> testClass) {
                List<FrameworkMethod> methodsAnnotatedWithGiven = super.getMethods(testClass);
                ArrayList<FrameworkMethod> ret = new ArrayList<FrameworkMethod>(methodsAnnotatedWithGiven.size());
                for (FrameworkMethod each : methodsAnnotatedWithGiven) {
                    When ann = (When)each.getMethod().getAnnotation(this.getAnnotation());
                    ret.add(this.parse(testClass, ann));
                }
                return ret;
            }

            private CompositeFrameworkMethod parse(Class<?> testClass, When when) {
                CompositeFrameworkMethod.Builder b = new CompositeFrameworkMethod.Builder();
                b.setMode(CompositeFrameworkMethod.Mode.Or);
                for (String each : when.value()) {
                    b.addMethod(false, this.parse(testClass, each));
                }
                return b.build();
            }

            private FrameworkMethod parse(Class<?> testClass, String term) {
                CompositeFrameworkMethod.Builder b = new CompositeFrameworkMethod.Builder();
                b.setMode(CompositeFrameworkMethod.Mode.And);
                for (String each : term.replace(" ", "").split("&&")) {
                    boolean negateOperator = each.startsWith("!");
                    FrameworkMethod m = negateOperator ? FrameworkMethodUtils.getFrameworkMethodByName(testClass, each.substring(1)) : FrameworkMethodUtils.getFrameworkMethodByName(testClass, each);
                    b.addMethod(negateOperator, m);
                }
                return b.build();
            }
        };

        public List<FrameworkMethod> getMethods(Class<?> var1);

        public static abstract class FrameworkMethodRetrieverBase
        implements FrameworkMethodRetriever {
            @Override
            public List<FrameworkMethod> getMethods(Class<?> testClass) {
                return new TestClass(testClass).getAnnotatedMethods(this.getAnnotation());
            }

            protected abstract Class<? extends Annotation> getAnnotation();
        }
    }

    public static interface FrameworkMethodValidator {
        public static final FrameworkMethodValidator CUSTOMTESTCASEMETHOD_VALIDATOR = new FrameworkMethodValidator(){

            @Override
            public void validate(Class<?> testClass, FrameworkMethod method, List<String> errors) {
                Method mm = method.getMethod();
                if (!method.isPublic() && method.isStatic() && mm.getParameterTypes().length == 0 && (Tuple.class.isAssignableFrom(mm.getReturnType()) || Iterable.class.isAssignableFrom(mm.getReturnType()))) {
                    errors.add("error");
                }
            }
        };
        public static final FrameworkMethodValidator VALIDATOR_FOR_METHOD_REFERENCEDBY_WHEN = new FrameworkMethodValidator(){

            @Override
            public void validate(Class<?> testClass, FrameworkMethod method, List<String> errors) {
                FrameworkMethodUtils.validatePreconditionFrameworkMethod(testClass, method, errors);
            }
        };
        public static final FrameworkMethodValidator PRECONDITIONMETHOD_VALIDATOR = new FrameworkMethodValidator(){

            @Override
            public void validate(Class<?> testClass, FrameworkMethod method, List<String> errors) {
                FrameworkMethodUtils.validatePreconditionFrameworkMethod(testClass, method, errors);
            }
        };

        public void validate(Class<?> var1, FrameworkMethod var2, List<String> var3);
    }
}

