/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.exceptions.InvalidPluginException;
import com.github.dakusui.jcunit.exceptions.InvalidTestException;
import com.github.dakusui.jcunit.exceptions.JCUnitEnvironmentException;
import com.github.dakusui.jcunit.exceptions.JCUnitException;
import com.github.dakusui.jcunit.exceptions.UndefinedSymbol;
import java.util.LinkedList;

public class Checks {
    private Checks() {
    }

    public static <T> T checknotnull(T obj) {
        Checks.checknotnull(obj, null, new Object[0]);
        return obj;
    }

    public static <T> T checknotnull(T obj, String msgOrFmt, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(Checks.composeMessage(msgOrFmt, args));
        }
        return obj;
    }

    public static void checkcond(boolean b) {
        Checks.checkcond(b, null, new Object[0]);
    }

    public static void checkcond(boolean b, String msgOrFmt, Object ... args) {
        if (!b) {
            throw new IllegalStateException(Checks.composeMessage(msgOrFmt, args));
        }
    }

    public static void checkparam(boolean b) {
        Checks.checkparam(b, null, new Object[0]);
    }

    public static void checkparam(boolean b, String msgOrFmt, Object ... args) {
        if (!b) {
            throw new IllegalArgumentException(Checks.composeMessage(msgOrFmt, args));
        }
    }

    public static void checkplugin(boolean cond, String msg, Object ... args) {
        if (!cond) {
            throw new InvalidPluginException(Checks.composeMessage(msg, args), null);
        }
    }

    public static void checkenv(boolean cond, String msg, Object ... args) {
        if (!cond) {
            throw new JCUnitEnvironmentException(Checks.composeMessage(msg, args), null);
        }
    }

    public static void checktest(boolean cond, String msg, Object ... args) {
        if (!cond) {
            throw new InvalidTestException(Checks.composeMessage(msg, args));
        }
    }

    public static void checksymbols(Tuple tuple, String ... factorNames) throws UndefinedSymbol {
        LinkedList<String> missings = new LinkedList<String>();
        for (String each : factorNames) {
            if (Checks.checknotnull(tuple).containsKey(each)) continue;
            missings.add(each);
        }
        if (!missings.isEmpty()) {
            throw new UndefinedSymbol(missings.toArray(new String[missings.size()]));
        }
    }

    public static void rethrow(Throwable e, String msgOrFmt, Object ... args) {
        throw new JCUnitException(Checks.composeMessage(msgOrFmt, args), e);
    }

    public static void rethrow(Throwable e) {
        Checks.rethrow(e, e.getMessage(), new Object[0]);
    }

    public static void rethrowpluginerror(Throwable throwable, String msgOrFmt, Object ... args) {
        throw new InvalidPluginException(Checks.composeMessage(msgOrFmt, args), throwable);
    }

    public static void rethrowtesterror(Throwable throwable, String msgOrFmt, Object ... args) {
        throw new InvalidTestException(Checks.composeMessage(msgOrFmt, args), throwable);
    }

    private static String composeMessage(String msgOrFmt, Object ... args) {
        if (msgOrFmt != null) {
            return String.format(msgOrFmt, args);
        }
        return String.format("Message:'%s'", Utils.join(",", args));
    }

    public static void fail() {
        throw new IllegalStateException();
    }
}

