/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.ProcessKiller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FFMPEGExecutor {
    private static final Logger log = LoggerFactory.getLogger(FFMPEGExecutor.class);
    private String ffmpegExecutablePath;
    private ArrayList args = new ArrayList();
    private Process ffmpeg = null;
    private ProcessKiller ffmpegKiller = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private InputStream errorStream = null;

    public FFMPEGExecutor(String ffmpegExecutablePath) {
        this.ffmpegExecutablePath = ffmpegExecutablePath;
    }

    public void addArgument(String arg) {
        this.args.add(arg);
    }

    public void execute() throws IOException {
        int argsSize = this.args.size();
        Object[] cmd = new String[argsSize + 1];
        cmd[0] = this.ffmpegExecutablePath;
        for (int i = 0; i < argsSize; ++i) {
            cmd[i + 1] = (String)this.args.get(i);
        }
        Runtime runtime = Runtime.getRuntime();
        log.info("exec cmd: {}", (Object)Arrays.toString(cmd));
        this.ffmpeg = runtime.exec((String[])cmd);
        this.ffmpegKiller = new ProcessKiller(this.ffmpeg);
        runtime.addShutdownHook(this.ffmpegKiller);
        this.inputStream = this.ffmpeg.getInputStream();
        this.outputStream = this.ffmpeg.getOutputStream();
        this.errorStream = this.ffmpeg.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void destroy() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.outputStream = null;
        }
        if (this.errorStream != null) {
            try {
                this.errorStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.errorStream = null;
        }
        if (this.ffmpeg != null) {
            this.ffmpeg.destroy();
            this.ffmpeg = null;
        }
        if (this.ffmpegKiller != null) {
            Runtime runtime = Runtime.getRuntime();
            runtime.removeShutdownHook(this.ffmpegKiller);
            this.ffmpegKiller = null;
        }
    }
}

