/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.FFMPEGLocator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFFMPEGLocator
extends FFMPEGLocator {
    private static final Logger log = LoggerFactory.getLogger(DefaultFFMPEGLocator.class);
    private static final int MYEX_EVERSION = 1;
    private static final String WINDOWS = "windows";
    private static final String MAC = "mac";
    private String path;

    public DefaultFFMPEGLocator() {
        File dll;
        boolean isWindows;
        boolean isMac = false;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains(WINDOWS)) {
            isWindows = true;
        } else {
            isWindows = false;
            isMac = os.contains(MAC);
        }
        File temp = null;
        String ffmpegHome = System.getProperty("ffmpeg.home");
        if (ffmpegHome != null && !"".equals(ffmpegHome)) {
            log.info("ffmpeg.home: " + ffmpegHome);
            temp = new File(ffmpegHome);
        }
        if (temp == null || !temp.exists()) {
            temp = new File(System.getProperty("java.io.tmpdir"), "jave-1");
            log.info("ffmpeg.home does not exists, use default bin path: " + temp.getAbsolutePath());
        }
        if (!temp.exists()) {
            temp.mkdirs();
            temp.deleteOnExit();
        }
        String suffix = isWindows ? ".exe" : (isMac ? "-mac" : "");
        File exe = new File(temp, "ffmpeg" + suffix);
        if (!exe.exists() || exe.length() <= 0L) {
            this.copyFile("bin/ffmpeg" + suffix, exe);
        }
        if (isWindows && !(dll = new File(temp, "pthreadGC2.dll")).exists()) {
            this.copyFile("bin/pthreadGC2.dll", dll);
        }
        if (!isWindows) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec(new String[]{"/bin/chmod", "755", exe.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.path = exe.getAbsolutePath();
    }

    @Override
    protected String getFFMPEGExecutablePath() {
        return this.path;
    }

    private void copyFile(String path, File dest) throws RuntimeException {
        InputStream input = null;
        OutputStream output = null;
        try {
            int l;
            input = this.getClass().getClassLoader().getResourceAsStream(path);
            output = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((l = input.read(buffer)) != -1) {
                output.write(buffer, 0, l);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write file " + dest.getAbsolutePath());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (!dest.exists()) {
            String errMsg = "copy ffmpeg executable file to " + dest.getAbsolutePath() + " fail";
            log.info(errMsg);
            throw new IllegalStateException(errMsg);
        }
    }
}

