/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.IgnoreErrorEncoder;
import java.io.File;

public class AudioUtils {
    private static final String LIBMP_3_LAME = "libmp3lame";

    public static void amrToMp3(String sourcePath, String targetPath) {
        File source = new File(sourcePath);
        File target = new File(targetPath);
        AudioUtils.amrToMp3(source, target);
    }

    public static void amrToMp3(File source, File target) {
        AudioUtils.convert(source, target, "mp3");
    }

    public static void amrToWav(File source, File target) {
        AudioUtils.convert(source, target, "wav");
    }

    public static void convert(File source, File target, String format) {
        if (!source.exists()) {
            throw new IllegalArgumentException("source file does not exists: " + source.getAbsoluteFile());
        }
        AudioAttributes audio = new AudioAttributes();
        IgnoreErrorEncoder encoder = new IgnoreErrorEncoder();
        audio.setCodec(LIBMP_3_LAME);
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat(format);
        attrs.setAudioAttributes(audio);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Exception e) {
            throw new IllegalStateException("convert amr to " + format + " error: ", e);
        }
    }
}

