/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.spring;

import com.github.dadiyang.httpinvoker.annotation.HttpApiScan;
import com.github.dadiyang.httpinvoker.propertyresolver.EnvironmentBasePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.MultiSourcePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertiesBasePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertyResolver;
import com.github.dadiyang.httpinvoker.requestor.RequestPreprocessor;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.spring.ClassPathHttpApiScanner;
import com.github.dadiyang.httpinvoker.util.IoUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HttpApiConfigurer
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiConfigurer.class);
    private static final String CLASSPATH_PRE = "classpath:";
    private static final String FILE_PRE = "file:";
    private ApplicationContext ctx;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        PropertyResolver resolver;
        Map beans = this.ctx.getBeansWithAnnotation(HttpApiScan.class);
        HashSet<String> basePackages = new HashSet<String>();
        Properties properties = new Properties();
        for (Map.Entry entry : beans.entrySet()) {
            String[] configPaths;
            HttpApiScan ann = entry.getValue().getClass().getAnnotation(HttpApiScan.class);
            if (ann.value().length <= 0 || ann.value()[0].isEmpty()) {
                basePackages.add(entry.getValue().getClass().getPackage().getName());
            } else {
                basePackages.addAll(Arrays.asList(ann.value()));
            }
            if ((configPaths = ann.configPaths()).length <= 0) continue;
            for (String path : configPaths) {
                if (path == null || path.isEmpty()) continue;
                try {
                    Properties p = IoUtils.getProperties(path);
                    properties.putAll((Map<?, ?>)p);
                }
                catch (IOException e) {
                    throw new IllegalStateException("read config error: " + path, e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("HttpApiScan packages: " + basePackages);
        }
        Requestor requestor = null;
        try {
            requestor = (Requestor)this.ctx.getBean(Requestor.class);
        }
        catch (Exception e) {
            logger.debug("Requestor bean does not exist: " + e.getMessage());
        }
        RequestPreprocessor requestPreprocessor = null;
        try {
            requestPreprocessor = (RequestPreprocessor)this.ctx.getBean(RequestPreprocessor.class);
        }
        catch (Exception e) {
            logger.debug("RequestPreprocessor bean does not exist" + e.getMessage());
        }
        ResponseProcessor responseProcessor = null;
        try {
            responseProcessor = (ResponseProcessor)this.ctx.getBean(ResponseProcessor.class);
        }
        catch (Exception e) {
            logger.debug("ResponseProcessor bean does not exist" + e.getMessage());
        }
        if (properties.size() > 0) {
            MultiSourcePropertyResolver multi = new MultiSourcePropertyResolver();
            multi.addPropertyResolver(new PropertiesBasePropertyResolver(properties));
            multi.addPropertyResolver(new EnvironmentBasePropertyResolver(this.ctx.getEnvironment()));
            resolver = multi;
        } else {
            resolver = new EnvironmentBasePropertyResolver(this.ctx.getEnvironment());
        }
        ClassPathHttpApiScanner scanner = new ClassPathHttpApiScanner(beanDefinitionRegistry, resolver, requestor, requestPreprocessor, responseProcessor);
        scanner.doScan(basePackages.toArray(new String[0]));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }
}

