/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultiPart {
    private List<Part> parts;

    public MultiPart() {
        this.parts = new LinkedList<Part>();
    }

    public MultiPart(List<Part> parts) {
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = parts;
    }

    public void addPart(Part part) {
        if (part == null) {
            throw new IllegalArgumentException("part cannot be null");
        }
        this.parts.add(part);
    }

    public List<Part> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public boolean remove(Part part) {
        if (part == null) {
            throw new IllegalArgumentException("part cannot be null");
        }
        return this.parts.remove(part);
    }

    public static class Part {
        private String key;
        private String value;
        private InputStream inputStream;

        public Part() {
        }

        public Part(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Part(String key, String value, InputStream inputStream) {
            this.key = key;
            this.value = value;
            this.inputStream = inputStream;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }
}

