/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private int statusCode;
    private String statusMessage;
    private String charset;
    private String contentType;
    private byte[] bodyAsBytes;
    private String body;
    private InputStream bodyStream;
    private Map<String, List<String>> headers;
    private Map<String, String> cookies;

    public HttpResponse() {
    }

    public HttpResponse(int statusCode, String statusMessage, String contentType) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.contentType = contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getBodyAsBytes() {
        return this.bodyAsBytes;
    }

    public void setBodyAsBytes(byte[] bodyAsBytes) {
        this.bodyAsBytes = bodyAsBytes;
    }

    public InputStream getBodyStream() {
        return this.bodyStream;
    }

    public void setBodyStream(InputStream bodyStream) {
        this.bodyStream = bodyStream;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String header = entry.getKey();
            List<String> values = entry.getValue();
            if (values.size() <= 0) continue;
            map.put(header, values.get(0));
        }
        return map;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> multiHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        return Arrays.asList(this.getHeader(name).split(";\\s?"));
    }

    public String getHeader(String name) {
        return this.getHeaders().get(name);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public String getCookie(String name) {
        return this.getCookies().get(name);
    }
}

