/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.dadiyang.httpinvoker.requestor.HttpClientResponse;
import com.github.dadiyang.httpinvoker.requestor.HttpRequest;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.MultiPart;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import com.github.dadiyang.httpinvoker.util.ParamUtils;
import com.github.dadiyang.httpinvoker.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestor
implements Requestor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestor.class);
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private CloseableHttpClient httpClient;

    public HttpClientRequestor(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientRequestor() {
        this.httpClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
    }

    @Override
    public HttpResponse sendRequest(HttpRequest request) throws IOException {
        String method = StringUtils.upperCase(request.getMethod());
        if (ObjectUtils.equals(method, "GET")) {
            return this.sendGet(request);
        }
        if (ObjectUtils.equals(method, "POST")) {
            return this.sendPost(request);
        }
        if (ObjectUtils.equals(method, "PUT")) {
            return this.sendPut(request);
        }
        if (ObjectUtils.equals(method, "DELETE")) {
            return this.sendDelete(request);
        }
        if (ObjectUtils.equals(method, "PATCH")) {
            return this.sendPatch(request);
        }
        if (ObjectUtils.equals(method, "HEAD")) {
            return this.sendHead(request);
        }
        if (ObjectUtils.equals(method, "OPTIONS")) {
            return this.sendOptions(request);
        }
        if (ObjectUtils.equals(method, "TRACE")) {
            return this.sendTrace(request);
        }
        throw new IllegalArgumentException("Unsupported http method: " + method);
    }

    private HttpResponse sendTrace(HttpRequest request) throws IOException {
        String fullUrl = request.getUrl() + ParamUtils.toQueryString(request.getData());
        HttpTrace httpTrace = new HttpTrace(fullUrl);
        return this.sendRequest(request, (HttpRequestBase)httpTrace);
    }

    private HttpResponse sendOptions(HttpRequest request) throws IOException {
        String fullUrl = request.getUrl() + ParamUtils.toQueryString(request.getData());
        HttpOptions httpOptions = new HttpOptions(fullUrl);
        return this.sendRequest(request, (HttpRequestBase)httpOptions);
    }

    private HttpResponse sendHead(HttpRequest request) throws IOException {
        String fullUrl = request.getUrl() + ParamUtils.toQueryString(request.getData());
        HttpHead httpHead = new HttpHead(fullUrl);
        return this.sendRequest(request, (HttpRequestBase)httpHead);
    }

    private HttpResponse sendPatch(HttpRequest request) throws IOException {
        HttpEntity entity = this.createHttpEntity(request);
        HttpPatch httpPatch = new HttpPatch(request.getUrl());
        httpPatch.setEntity(entity);
        return this.sendRequest(request, (HttpRequestBase)httpPatch);
    }

    private HttpResponse sendDelete(HttpRequest request) throws IOException {
        String fullUrl = request.getUrl() + ParamUtils.toQueryString(request.getData());
        HttpDelete httpDelete = new HttpDelete(fullUrl);
        return this.sendRequest(request, (HttpRequestBase)httpDelete);
    }

    private HttpResponse sendPut(HttpRequest request) throws IOException {
        HttpEntity entity = this.createHttpEntity(request);
        HttpPut httpPut = new HttpPut(request.getUrl());
        httpPut.setEntity(entity);
        return this.sendRequest(request, (HttpRequestBase)httpPut);
    }

    private HttpResponse sendPost(HttpRequest request) throws IOException {
        if (ParamUtils.isUploadRequest(request.getBody())) {
            MultiPart multiPart = !(request.getBody() instanceof MultiPart) ? ParamUtils.convertInputStreamAndFile(request) : (MultiPart)request.getBody();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setLaxMode();
            for (MultiPart.Part part : multiPart.getParts()) {
                if (part.getInputStream() != null) {
                    builder.addBinaryBody(part.getKey(), part.getInputStream(), ContentType.DEFAULT_BINARY, part.getValue());
                    continue;
                }
                ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
                builder.addTextBody(part.getKey(), part.getValue(), contentType);
            }
            HttpEntity entity = builder.build();
            HttpPost httpPost = new HttpPost(request.getUrl());
            httpPost.setEntity(entity);
            return this.sendMultiPartRequest(request, (HttpRequestBase)httpPost);
        }
        HttpEntity entity = this.createHttpEntity(request);
        HttpPost httpPost = new HttpPost(request.getUrl());
        httpPost.setEntity(entity);
        return this.sendRequest(request, (HttpRequestBase)httpPost);
    }

    private HttpEntity createHttpEntity(HttpRequest request) throws IOException {
        ByteArrayEntity entity;
        if (request.getHeaders() != null && ObjectUtils.equals(FORM_URLENCODED, request.getHeaders().get(CONTENT_TYPE))) {
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            Map<String, String> map = ParamUtils.toMapStringString(request.getData(), "");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            entity = new UrlEncodedFormEntity(parameters, "UTF-8");
        } else if (request.getBody() != null) {
            entity = new ByteArrayEntity(JSON.toJSONBytes((Object)request.getBody(), (SerializerFeature[])new SerializerFeature[0]), ContentType.create((String)APPLICATION_JSON, (String)"UTF-8"));
        } else if (request.getData() != null) {
            entity = new ByteArrayEntity(JSON.toJSONBytes(request.getData(), (SerializerFeature[])new SerializerFeature[0]), ContentType.create((String)APPLICATION_JSON, (String)"UTF-8"));
        } else {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContentLength(0L);
            entity = basicHttpEntity;
        }
        return entity;
    }

    private HttpResponse sendGet(HttpRequest request) throws IOException {
        String fullUrl = request.getUrl() + ParamUtils.toQueryString(request.getData());
        HttpGet httpGet = new HttpGet(fullUrl);
        return this.sendRequest(request, (HttpRequestBase)httpGet);
    }

    private HttpResponse sendRequest(HttpRequest request, HttpRequestBase httpRequestBase) throws IOException {
        this.prepare(request, httpRequestBase);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        if (response.getEntity() != null) {
            response.setEntity((HttpEntity)new BufferedHttpEntity(response.getEntity()));
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return new HttpClientResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse sendMultiPartRequest(HttpRequest request, HttpRequestBase httpRequestBase) throws IOException {
        this.prepare(request, httpRequestBase);
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.createHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);
            response.setEntity((HttpEntity)new BufferedHttpEntity(response.getEntity()));
            EntityUtils.consume((HttpEntity)response.getEntity());
            HttpClientResponse httpClientResponse = new HttpClientResponse(response);
            return httpClientResponse;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    private void prepare(HttpRequest request, HttpRequestBase httpRequestBase) {
        this.addHeaders(request, (HttpMessage)httpRequestBase);
        this.addCookies(request, (HttpMessage)httpRequestBase);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(request.getTimeout()).build();
        httpRequestBase.setConfig(requestConfig);
    }

    private void addCookies(HttpRequest request, HttpMessage msg) {
        Map<String, String> cookies = request.getCookies();
        if (cookies == null || cookies.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        msg.addHeader("Cookie", sb.substring(0, sb.length()));
    }

    private void addHeaders(HttpRequest request, HttpMessage msg) {
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                msg.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

