/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.foundation.audit;

import com.github.dactiv.common.spring.mail.JavaMailService;
import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.OperatingState;
import com.github.dactiv.showcase.entity.foundation.audit.OperatingRecord;
import com.github.dactiv.showcase.service.foundation.SystemAuditManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/foundation/audit/operating-record"})
public class OperatingRecordController {
    @Autowired
    private SystemAuditManager systemAuditManager;
    @Autowired
    private JavaMailService javaMailService;
    @Value(value="${mail.exception.receive}")
    private String mailReceive;

    @RequestMapping(value={"view"})
    public Page<OperatingRecord> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.get((HttpServletRequest)request, (boolean)true);
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("id");
            pageRequest.setOrderDir("desc");
        }
        request.setAttribute("operatingState", (Object)SystemVariableUtils.getVariables(OperatingState.class, (Object[])new Object[0]));
        return this.systemAuditManager.searchOperatingRecordPage(pageRequest, filters);
    }

    @RequestMapping(value={"read"})
    public String read(Model model, @RequestParam(value="id") String id) {
        model.addAttribute("entity", (Object)this.systemAuditManager.getOperatingRecord(id));
        return "/foundation/audit/operating-record/read";
    }

    @ResponseBody
    @RequestMapping(value={"send-error"})
    public String sendError(@RequestParam(value="id") String id) {
        OperatingRecord value = this.systemAuditManager.getOperatingRecord(id);
        Hibernate.initialize((Object)value);
        Map<String, OperatingRecord> model = Collections.singletonMap("entity", value);
        try {
            this.javaMailService.sendByTemplate(this.mailReceive, "base-curd-project", "\u5f02\u5e38\u9519\u8bef\u62a5\u544a", "operating-mail-template.ftl", null, model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "\u53d1\u9001\u6210\u529f";
    }
}

