/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.account;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilter;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.GroupType;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.dao.account.GroupDao;
import com.github.dactiv.showcase.dao.account.ResourceDao;
import com.github.dactiv.showcase.dao.account.UserDao;
import com.github.dactiv.showcase.entity.account.Group;
import com.github.dactiv.showcase.entity.account.Resource;
import com.github.dactiv.showcase.entity.account.User;
import com.github.dactiv.showcase.service.ServiceException;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountManager {
    @Autowired
    private UserDao userDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private GroupDao groupDao;

    @CacheEvict(value={"shiroAuthenticationCache"}, key="T(com.github.dactiv.showcase.common.SystemVariableUtils).getSessionVariable().getUser().getUsername()")
    public void updateUserPassword(String oldPassword, String newPassword) {
        User user = SystemVariableUtils.getSessionVariable().getUser();
        oldPassword = new SimpleHash("MD5", (Object)oldPassword.toCharArray()).toString();
        if (!user.getPassword().equals(oldPassword)) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e.");
        }
        String temp = new SimpleHash("MD5", (Object)newPassword).toHex();
        this.userDao.updatePassword(user.getId(), temp);
        user.setPassword(temp);
    }

    public User getUser(String id) {
        return (User)this.userDao.load((Serializable)((Object)id));
    }

    public Page<User> searchUserPage(PageRequest request, List<PropertyFilter> filters) {
        return this.userDao.findPage(request, filters);
    }

    public void insertUser(User entity) {
        if (!this.isUsernameUnique(entity.getUsername())) {
            throw new ServiceException("\u767b\u5f55\u5e10\u53f7\u5df2\u5b58\u5728");
        }
        String password = new SimpleHash("MD5", (Object)entity.getPassword()).toHex();
        entity.setPassword(password);
        this.userDao.insert((Object)entity);
    }

    @CacheEvict(value={"shiroAuthenticationCache"}, key="#entity.getUsername()")
    public void updateUser(User entity) {
        this.userDao.update((Object)entity);
    }

    public boolean isUsernameUnique(String username) {
        return this.getUserByUsername(username) == null;
    }

    public void deleteUsers(List<String> ids) {
        for (String id : ids) {
            this.deleteUser((User)this.userDao.get((Serializable)((Object)id)));
        }
    }

    @CacheEvict(value={"shiroAuthenticationCache"}, key="#entity.getUsername()")
    public void deleteUser(User entity) {
        this.userDao.delete((Object)entity);
    }

    public User getUserByUsername(String username) {
        return (User)this.userDao.findUniqueByProperty("username", (Object)username);
    }

    public Resource getResource(String id) {
        return (Resource)this.resourceDao.load((Serializable)((Object)id));
    }

    public List<Resource> getResources(List<String> ids) {
        return this.resourceDao.get(ids);
    }

    public List<Resource> getParentResources() {
        ArrayList filters = Lists.newArrayList((Object[])new PropertyFilter[]{PropertyFilters.get((String)"EQS_parent.id", (String)"null")});
        return this.resourceDao.findByPropertyFilter((List)filters, new Order[]{Order.asc((String)"sort")});
    }

    public void saveResource(Resource entity) {
        if (entity.getSort() == null) {
            entity.setSort(Long.valueOf(this.resourceDao.entityCount(new PropertyFilter[0]) + 1L));
        }
        this.resourceDao.save((Object)entity);
    }

    public void deleteResources(List<String> ids) {
        this.resourceDao.deleteAll(ids);
    }

    public List<Resource> getResources(String ... ignoreIdValue) {
        ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
        if (ArrayUtils.isNotEmpty((Object[])ignoreIdValue)) {
            filters.add(PropertyFilters.get((String)"NES_id", (String)StringUtils.join((Object[])ignoreIdValue, (String)",")));
        }
        return this.resourceDao.findByPropertyFilter(filters, new Order[]{Order.asc((String)"sort")});
    }

    public long getResourceCount() {
        return this.resourceDao.entityCount(new PropertyFilter[0]);
    }

    public List<Resource> getUserResources(String userId) {
        return this.resourceDao.getUserResources(userId);
    }

    public List<Resource> mergeResourcesToParent(List<Resource> list, ResourceType ignoreType) {
        return this.resourceDao.mergeToParent(list, ignoreType);
    }

    public Group getGroup(String id) {
        return (Group)this.groupDao.load((Serializable)((Object)id));
    }

    public List<Group> getGroups(List<String> ids) {
        return this.groupDao.get(ids);
    }

    @CacheEvict(value={"shiroAuthorizationCache"}, allEntries=true)
    public void saveGroup(Group entity) {
        this.groupDao.save((Object)entity);
    }

    @CacheEvict(value={"shiroAuthorizationCache"}, allEntries=true)
    public void deleteGroups(List<String> ids) {
        this.groupDao.deleteAll(ids);
    }

    public List<Group> getGroups(GroupType groupType, String ... ignoreIdValue) {
        ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
        if (ArrayUtils.isNotEmpty((Object[])ignoreIdValue)) {
            filters.add(PropertyFilters.get((String)"NES_id", (String)StringUtils.join((Object[])ignoreIdValue, (String)",")));
        }
        filters.add(PropertyFilters.get((String)"EQS_type", (String)groupType.getValue()));
        return this.groupDao.findByPropertyFilter(filters, new Order[0]);
    }

    public List<Group> getParentGroups(GroupType type) {
        ArrayList filters = Lists.newArrayList((Object[])new PropertyFilter[]{PropertyFilters.get((String)"EQS_parent.id", (String)"null"), PropertyFilters.get((String)"EQS_type", (String)type.getValue())});
        return this.groupDao.findByPropertyFilter((List)filters, new Order[]{Order.asc((String)"id")});
    }
}

