/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.account;

import com.github.dactiv.orm.annotation.TreeEntity;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.entity.IdEntity;
import com.github.dactiv.showcase.entity.account.Group;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@TreeEntity
@Table(name="TB_RESOURCE")
@NamedQuery(name="userResources", query="select rl from User u left join u.groupsList gl left join gl.resourcesList rl where u.id=?1 and gl.type= '03' and gl.state = 1 order by rl.sort")
public class Resource
extends IdEntity {
    private static final long serialVersionUID = 1L;
    public static final String UserResources = "userResources";
    private String name;
    private String value;
    private Resource parent;
    private Long sort;
    private Boolean leaf = Boolean.FALSE;
    private List<Resource> children = new ArrayList();
    private String remark;
    private String type;
    private List<Group> groupsList = new ArrayList();
    private String permission;
    private String icon;

    @NotEmpty
    @Length(max=32)
    @Column(length=32, nullable=false, unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(max=256)
    @Column(length=256)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_PARENT_ID")
    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    @Min(value=0L)
    @NotNull
    @Column(nullable=false)
    public Long getSort() {
        return this.sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    @Column(nullable=false)
    public Boolean getLeaf() {
        return this.leaf;
    }

    public void setLeaf(Boolean leaf) {
        this.leaf = leaf;
    }

    @OrderBy(value="sort ASC")
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<Resource> getChildren() {
        return this.children;
    }

    public void setChildren(List<Resource> children) {
        this.children = children;
    }

    @Length(max=512)
    @Column(length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @NotEmpty
    @Length(min=2, max=2)
    @Column(nullable=false, length=2)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="TB_GROUP_RESOURCE", joinColumns={@JoinColumn(name="FK_RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="FK_GROUP_ID")})
    public List<Group> getGroupsList() {
        return this.groupsList;
    }

    public void setGroupsList(List<Group> groupsList) {
        this.groupsList = groupsList;
    }

    @Transient
    public String getParentName() {
        return this.parent == null ? "" : this.parent.getName();
    }

    @Transient
    public String getParentId() {
        return this.parent == null ? "" : this.parent.getId();
    }

    @Length(max=64)
    @Column(length=64)
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Length(max=32)
    @Column(length=32)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Transient
    public String getTypeName() {
        return SystemVariableUtils.getName(ResourceType.class, (Object)this.type);
    }
}

