/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.dao.account;

import com.github.dactiv.orm.core.hibernate.support.HibernateSupportDao;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.entity.account.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ResourceDao
extends HibernateSupportDao<Resource, String> {
    public List<Resource> getUserResources(String userId) {
        return this.distinct("userResources", new Object[]{userId});
    }

    public List<Resource> mergeToParent(List<Resource> list, ResourceType ignoreType) {
        this.getSessionFactory().getCurrentSession().clear();
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : list) {
            if (r.getParent() != null || StringUtils.equals((CharSequence)ignoreType.getValue(), (CharSequence)r.getType())) continue;
            this.mergeToParent(list, r, ignoreType);
            result.add(r);
        }
        return result;
    }

    private void mergeToParent(List<Resource> list, Resource parent, ResourceType ignoreType) {
        if (!parent.getLeaf().booleanValue()) {
            return;
        }
        parent.setChildren(new ArrayList());
        parent.setLeaf(Boolean.valueOf(false));
        for (Resource r : list) {
            if (StringUtils.equals((CharSequence)r.getType(), (CharSequence)ignoreType.getValue()) || !StringUtils.equals((CharSequence)r.getParentId(), (CharSequence)parent.getId())) continue;
            r.setChildren(null);
            this.mergeToParent(list, r, ignoreType);
            parent.getChildren().add(r);
            parent.setLeaf(Boolean.valueOf(true));
        }
    }
}

