/**
 * 通过jquery重写所有js插件的默认值和设置一些属性让页面更好的展示
 */
(function($){
	//删除背景遮罩
	var removeBackdrop = function(form){
		//获取form中的data-backdrop属性，该属性指向这背景遮罩的div id
		var backdrop = $(form.attr("data-backdrop"));
		//如果在form没有使用背景遮罩，可能在form的某些地方有。
		if (backdrop.length === 0) {
			backdrop = form;
		}
		//查询出div有formid的div，全部删除。
		backdrop.find("div[for='"+form.attr("id")+"']").remove();
	};
	
	//重写ajaxForm的设置
	$.defaultAjaxFormSetting = {
			//重写提交form前的方法，提交前添加一个背景遮罩到form中，挡住所有表单的内容
			beforeSubmit:function(formData, jqForm, options){
				//获取提交前是否要执行某个js方法
				var fn = jqForm.attr("onbeforesubmit");
				//如果没有要执行的方法，或者执行了方法后返回false，将不提交form
				if ($.isNotEmpty(fn) && window[fn](formData, jqForm, options) === false) {
					return false;
				}
				//获取当前form的data-backdrop属性
				var backdrop = $(jqForm.attr("data-backdrop"));
				//如果没有，将添加一个div做背景遮罩
				if (backdrop.length === 0) {
					backdrop = jqForm;
				}
				
				var mask = $("<div>").addClass("modal-backdrop fade in").attr("for",jqForm.attr("id"));
				backdrop.append(mask);
				
			},
			//重写提交成功方法，当完成提交后，将该form的背景遮罩div删除
			success:function(responseText, statusText, xhr, form){
				//删除背景遮罩
				removeBackdrop(form);
				//如果存在提交完成后要执行某个函数，就去执行该函数
				var fn = form.attr("onsuccess");
				if ($.isNotEmpty(fn)) {
					window[fn](responseText, statusText, xhr, form);
				}
			},
			//重写提交错误方法，当提交错误后，将该form的背景遮罩div删除
			error:function(response, statusText, message, form) {
				//删除背景遮罩
				removeBackdrop(form);
				//如果存在提交错误后要执行某个函数，就去执行该函数
				var fn = form.attr("onerror");
				if ($.isNotEmpty(fn)) {
					window[fn](response, statusText, message, form);
				}
			}
	};
	
	//初始化所有bootstrap控件，当document ready时
	var initComponent = function(){
		//如果存在modal控件，当展示modal时将焦点放到form表单的第一个文本域中
		$(".modal").on("shown.bs.modal",function(){
			$(this).find("form :input:not(:disabled):not(:hidden)").first().focus();
		});
		//如果存在form表单，将定义自己的form表单属性
		//当一个form的install属性没有，或者为false时，最做each下面的动作
		$("form[install!='true']").each(function(i,o){
			var temp = $(o);
			//将交单放到表单的第一个文本域中
			temp.find(":input:not(:disabled):not(:hidden)").first().focus();
			//判断是否有id，如果没有id将会用action的内容，做转换,如aciont="a/b/c"那么id为"a-b-c"
			var id = temp.attr("id") || temp.attr("action").substring(temp.attr("action").indexOf("/") + 1,temp.attr("action").length);
			temp.attr("id",id.replace(/\//g,"-"));
			//判断该form是否需要ajax提交。如果是，将使用submitHandler方式进行验证，否则就按常规去做验证
			if ($.value(temp.attr("data-ajax-submit"),"false").booleanValue()) {
				temp.validate({
					submitHandler : function(form) {
						temp.ajaxSubmit($.defaultAjaxFormSetting);
					}
				});
			} else {
				temp.validate();
			}
			
			//如果该form存在reset按钮，将自己去reset这一切
			temp.find("button[type='reset']").click(function(){
				
				temp.find("input:not(:disabled):not(:hidden)").each(function(i,field){
					$(field).val("");
				});
				
				temp.find("select:not(:disabled):not(:hidden)").each(function(i,field){
					$(field).val("");
				});
				
				temp.find("textarea:not(:disabled):not(:hidden)").each(function(i,field){
					$(field).val("");
				});
				
				return false;
			});
			
			temp.attr("install",true);
		});
	};

	//重写验证控件的展示错误
	$.validator.setDefaults({
		//重写验证出错函数
		showErrors : function(errorMap, errorList) {
			//如果存在验证成功的集合，将删除has-error和tooltop
			$.each(this.successList,function(i,e){
				var element = $(e);
				element.parent("div").removeClass("has-error");
				element.tooltip("destroy");
			});
			//如果存在错误字段，将做each下的动作
			$.each(errorList, function(i, e) {
				//获取当前错误的元素
				var element = $(e.element);
				//获取当前元素对应的tooltip
				var tip = element.data('bs.tooltip');
				//如果没有，将创建一个tooltip,如果存在了，就直接改变tooltip的html内容
				if ($.isNotEmpty(tip)) {
					tip.options.title = e.message;
					//设置tooltip的信息
					element.next().children(".tooltip-inner").html(e.message);
				} else {
					element.parent("div").addClass("has-error");
					element.tooltip({
						title:e.message,
						trigger:"focus"
					});
				}
			});
		}
	});
	
	$(document).ready(function(){
	    //判断浏览器版本，如果太低，就不能做任何事情
	    if ($.browser.msie && $.browser.version < 8) {
	    	$(".main-container").html(
		    	'<div class="server-exception">' +
		    		'<p><center><img class="" src="resource/image/ie.png"></center></p>' +
		    		'<p>&nbsp;</p>' +
		    		'<h3>浏览器不兼容</h3>' +
		    		'<p>您的刘浏览器版本过低，<a href="http://windows.microsoft.com/zh-cn/internet-explorer/download-ie">请升级IE到最新版本</a></p>' +
		    	'</div>'
	    	);
	    } else {
			initComponent();
	    }
	});
	
})(jQuery);
