/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.account;

import com.github.dactiv.showcase.service.account.CaptchaAuthenticationFilter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.stereotype.Component;

@Component
public class CaptchaAuthenticationFilter
extends FormAuthenticationFilter {
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    public static final String DEFAULT_SHOW_CAPTCHA_KEY_ATTRIBUTE = "showCaptcha";
    private static final String DEFAULT_LOGIN_NUM_KEY_ATTRIBUTE = "loginNum";
    private String captchaParam = "captcha";
    private String sessionCaptchaKeyAttribute = "captcha";
    private String loginNumKeyAttribute = "loginNum";
    private String sessionShowCaptchaKeyAttribute = "showCaptcha";
    private Integer allowLoginNum = 1;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        Session session = this.getSubject(request, response).getSession();
        Integer number = (Integer)session.getAttribute((Object)this.getLoginNumKeyAttribute());
        if (number == null) {
            number = new Integer(1);
            session.setAttribute((Object)this.getLoginNumKeyAttribute(), (Object)number);
        }
        if (number > this.getAllowLoginNum()) {
            String currentCaptcha = (String)session.getAttribute((Object)this.getSessionCaptchaKeyAttribute());
            String submitCaptcha = this.getCaptcha(request);
            if (StringUtils.isEmpty((CharSequence)submitCaptcha) || !StringUtils.equals((CharSequence)currentCaptcha, (CharSequence)submitCaptcha.toLowerCase())) {
                return this.onLoginFailure(this.createToken(request, response), (AuthenticationException)new AccountException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e"), request, response);
            }
        }
        return super.executeLogin(request, response);
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setSessionCaptchaKeyAttribute(String sessionCaptchaKeyAttribute) {
        this.sessionCaptchaKeyAttribute = sessionCaptchaKeyAttribute;
    }

    public String getSessionCaptchaKeyAttribute() {
        return this.sessionCaptchaKeyAttribute;
    }

    public String getLoginNumKeyAttribute() {
        return this.loginNumKeyAttribute;
    }

    public void setLoginNumKeyAttribute(String loginNumKeyAttribute) {
        this.loginNumKeyAttribute = loginNumKeyAttribute;
    }

    public String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public String getSessionShowCaptchaKeyAttribute() {
        return this.sessionShowCaptchaKeyAttribute;
    }

    public void setSessionShowCaptchaKeyAttribute(String sessionShowCaptchaKeyAttribute) {
        this.sessionShowCaptchaKeyAttribute = sessionShowCaptchaKeyAttribute;
    }

    public Integer getAllowLoginNum() {
        return this.allowLoginNum;
    }

    public void setAllowLoginNum(Integer allowLoginNum) {
        this.allowLoginNum = allowLoginNum;
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        if (ae instanceof IncorrectCredentialsException) {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u6b63\u786e");
        } else {
            request.setAttribute(this.getFailureKeyAttribute(), (Object)ae.getMessage());
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        Session session = this.getSubject(request, response).getSession(false);
        Integer number = (Integer)session.getAttribute((Object)this.getLoginNumKeyAttribute());
        if (number > this.getAllowLoginNum() - 1) {
            session.setAttribute((Object)this.getSessionShowCaptchaKeyAttribute(), (Object)true);
            number = number + 1;
            session.setAttribute((Object)this.getLoginNumKeyAttribute(), (Object)number);
        }
        number = number + 1;
        session.setAttribute((Object)this.getLoginNumKeyAttribute(), (Object)number);
        return super.onLoginFailure(token, e, request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        Session session = subject.getSession(false);
        session.removeAttribute((Object)this.getLoginNumKeyAttribute());
        session.removeAttribute((Object)this.getSessionShowCaptchaKeyAttribute());
        session.setAttribute((Object)"sv", subject.getPrincipal());
        return super.onLoginSuccess(token, subject, request, response);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        String host = this.getHost(request);
        boolean rememberMe = false;
        String rememberMeValue = request.getParameter(this.getRememberMeParam());
        Integer rememberMeCookieValue = null;
        if (StringUtils.isNotEmpty((CharSequence)rememberMeValue)) {
            rememberMe = true;
            rememberMeCookieValue = NumberUtils.toInt((String)rememberMeValue);
        }
        return new UsernamePasswordTokeExtend(this, username, password, rememberMe, host, rememberMeCookieValue);
    }
}

