/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.account;

import com.github.dactiv.common.utils.CollectionUtils;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.State;
import com.github.dactiv.showcase.entity.IdEntity;
import com.github.dactiv.showcase.entity.account.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NamedQuery;

@Entity
@Table(name="TB_USER")
@NamedQuery(name="updatePassword", query="update User u set u.password = ?1 where u.id = ?2")
public class User
extends IdEntity {
    private static final long serialVersionUID = 1L;
    public static final String UpdatePassword = "updatePassword";
    private String username;
    private String password;
    private String realname;
    private Integer state;
    private String email;
    private List<Group> groupsList = new ArrayList();
    private String portrait;

    @Column(length=32, unique=true, nullable=false, updatable=false)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Column(nullable=false, length=32, updatable=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(length=64, nullable=false)
    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    @Column(nullable=false, length=1)
    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    @Column(length=128)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="TB_GROUP_USER", joinColumns={@JoinColumn(name="FK_USER_ID")}, inverseJoinColumns={@JoinColumn(name="FK_GROUP_ID")})
    public List<Group> getGroupsList() {
        return this.groupsList;
    }

    public void setGroupsList(List<Group> groupsList) {
        this.groupsList = groupsList;
    }

    @Transient
    public String getStateName() {
        return SystemVariableUtils.getName(State.class, (Object)this.state);
    }

    @Transient
    public String getGroupNames() {
        return CollectionUtils.extractToString((Collection)this.groupsList, (String)"name", (String)",");
    }

    @Column(length=256)
    public String getPortrait() {
        return this.portrait;
    }

    public void setPortrait(String portrait) {
        this.portrait = portrait;
    }
}

