/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.xgs;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.weapon.WeaponData;
import com.daxie.xops.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.weapon.WeaponModelType;
import com.daxie.xops.weapon.WeaponScopeMode;
import com.daxie.xops.weapon.WeaponShootingStance;
import com.daxie.xops.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.weapon.WeaponTextureType;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

class XGSWriter {
    private WeaponData[] weapon_data_array = null;

    public XGSWriter(WeaponData[] weapon_data_array) {
        this.weapon_data_array = weapon_data_array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Write(String xgs_filename) throws FileNotFoundException {
        if (this.weapon_data_array == null) {
            LogFile.WriteWarn((String)"[XGSWriter-Write] Data is null.", (boolean)true);
            return;
        }
        if (this.weapon_data_array.length != 23) {
            LogFile.WriteWarn((String)("[XGSWriter-Write] Invalid number of data. data_num:" + this.weapon_data_array.length), (boolean)true);
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(xgs_filename)));
        try {
            int i;
            dos.writeByte(88);
            dos.writeByte(71);
            dos.writeByte(83);
            dos.writeByte(0);
            dos.writeByte(1);
            dos.writeByte(0);
            dos.writeByte(14);
            dos.writeByte(0);
            dos.writeByte(23);
            dos.writeByte(0);
            dos.writeByte(29);
            dos.writeByte(0);
            dos.writeByte(8);
            dos.writeByte(0);
            for (i = 0; i < 23; ++i) {
                int itemp = this.weapon_data_array[i].GetAttackPower();
                byte[] b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetPenetration();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetFiringInterval();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetBulletSpeed();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetNumberOfBullets();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetReloadingTime();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetRecoil();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetErrorRangeMin();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetErrorRangeMax();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                Vector vtemp = this.weapon_data_array[i].GetPosition();
                itemp = Math.round(vtemp.GetX());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetY());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetZ());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                vtemp = this.weapon_data_array[i].GetFlashPosition();
                itemp = Math.round(vtemp.GetX());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetY());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetZ());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                vtemp = this.weapon_data_array[i].GetCartridgePosition();
                itemp = Math.round(vtemp.GetX());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetY());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetZ());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                WeaponShootingStance shooting_stance = this.weapon_data_array[i].GetShootingStance();
                itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = !this.weapon_data_array[i].GetRapidFireEnabledFlag() ? 1 : 0;
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                WeaponScopeMode scope_mode = this.weapon_data_array[i].GetScopeMode();
                itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                String texture_filename = this.weapon_data_array[i].GetTextureFilename();
                WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
                itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                String model_filename = this.weapon_data_array[i].GetModelFilename();
                WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
                itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(this.weapon_data_array[i].GetScale() * 10.0f);
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                vtemp = this.weapon_data_array[i].GetCartridgeVelocity();
                itemp = Math.round(vtemp.GetX());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = Math.round(vtemp.GetY());
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetSoundID();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = this.weapon_data_array[i].GetSoundVolume();
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
                itemp = !this.weapon_data_array[i].GetSuppressorEnabledFlag() ? 0 : 1;
                b = ByteFunctions.short_to_byte_le((short)((short)itemp));
                dos.write(b);
            }
            for (i = 0; i < 23; ++i) {
                int j;
                String name = this.weapon_data_array[22 - i].GetName();
                byte[] name_buffer = new byte[16];
                for (j = 0; j < 16; ++j) {
                    name_buffer[j] = 0;
                }
                for (j = 0; j < name.length() && j < 15; ++j) {
                    name_buffer[j] = (byte)name.charAt(j);
                }
                dos.write(name_buffer);
            }
            for (i = 0; i < 16; ++i) {
                dos.writeByte(0);
            }
        }
        catch (IOException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[XGSWriter-Write] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
                LogFile.WriteWarn((String)"[XGSWriter-Write] Below is the stack trace.", (boolean)true);
                LogFile.WriteWarn((String)str, (boolean)false);
                return;
            }
        }
    }
}

