/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.exe;

import com.daxie.tool.ByteFunctions;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.character.CharacterModelType;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.character.CharacterType;
import java.util.List;

class XOPSExeCharacterDataParser {
    private CharacterData[] character_data_array = new CharacterData[43];

    public XOPSExeCharacterDataParser(List<Byte> bin, int character_data_start_pos) {
        for (int i = 0; i < 43; ++i) {
            this.character_data_array[i] = new CharacterData();
        }
        int pos = character_data_start_pos;
        for (int i = 0; i < 43; ++i) {
            byte[] b = new byte[]{bin.get(pos), bin.get(pos + 1)};
            int itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterTextureType texture_type = CharacterBinSpecifierAndEnumConverter.GetCharacterTextureTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetTextureType(texture_type);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterModelType model_type = CharacterBinSpecifierAndEnumConverter.GetCharacterModelTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetModelType(model_type);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_ushort_le((byte[])b);
            this.character_data_array[i].SetHP(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterAILevel ai_level = CharacterBinSpecifierAndEnumConverter.GetCharacterAILevelFromBinSpecifier(itemp);
            this.character_data_array[i].SetAILevel(ai_level);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.character_data_array[i].SetWeaponID(0, itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.character_data_array[i].SetWeaponID(1, itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            pos += 2;
            CharacterType type = CharacterBinSpecifierAndEnumConverter.GetCharacterTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetType(type);
        }
    }

    public CharacterData[] GetCharacterDataArray() {
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }
}

