/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.tool.FilenameFunctions;
import com.daxie.xops.bd1.BD1Block;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BD1Parser {
    private Map<Integer, String> texture_filenames_map = new HashMap<Integer, String>();
    private List<BD1Block> blocks = new ArrayList<BD1Block>();

    public BD1Parser(String bd1_filename) throws FileNotFoundException {
        List bin = FileFunctions.GetFileAllBin((String)bd1_filename);
        int count = 0;
        byte[] texture_filename_buffer = new byte[31];
        for (int i = 0; i < 10; ++i) {
            int j;
            for (j = 0; j < 31; ++j) {
                texture_filename_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            String texture_filename_temp = new String(texture_filename_buffer);
            int first_null_pos = 30;
            for (j = 0; j < 30; ++j) {
                if (texture_filename_temp.charAt(j) != '\u0000') continue;
                first_null_pos = j;
                break;
            }
            texture_filename_temp = texture_filename_temp.substring(0, first_null_pos);
            texture_filename_temp = FilenameFunctions.ReplaceWindowsDelimiterWithLinuxDelimiter((String)texture_filename_temp);
            this.texture_filenames_map.put(i, texture_filename_temp);
        }
        byte[] block_num_buffer = new byte[]{(Byte)bin.get(count), (Byte)bin.get(count + 1)};
        int block_num = ByteFunctions.byte_to_ushort_le((byte[])block_num_buffer);
        count += 2;
        for (int i = 0; i < block_num; ++i) {
            float coordinate_temp;
            int k;
            int j;
            BD1Block block = new BD1Block();
            byte[] byte_buffer = new byte[4];
            for (j = 0; j < 8; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                coordinate_temp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
                block.SetVertexPositionX(j, coordinate_temp);
            }
            for (j = 0; j < 8; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                coordinate_temp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
                block.SetVertexPositionY(j, coordinate_temp);
            }
            for (j = 0; j < 8; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                coordinate_temp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
                block.SetVertexPositionZ(j, coordinate_temp);
            }
            for (j = 0; j < 24; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                coordinate_temp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
                block.SetU(j, coordinate_temp);
            }
            for (j = 0; j < 24; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                coordinate_temp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
                block.SetV(j, coordinate_temp);
            }
            for (j = 0; j < 6; ++j) {
                for (k = 0; k < 4; ++k) {
                    byte_buffer[k] = (Byte)bin.get(count);
                    ++count;
                }
                block.SetTextureID(j, (char)byte_buffer[0]);
            }
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            if (byte_buffer[0] != 0) {
                block.SetEnabledFlag(true);
            } else {
                block.SetEnabledFlag(false);
            }
            this.blocks.add(block);
        }
    }

    public List<BD1Block> GetBlocks() {
        return new ArrayList<BD1Block>(this.blocks);
    }

    public Map<Integer, String> GetTextureFilenamesMap() {
        return new HashMap<Integer, String>(this.texture_filenames_map);
    }
}

